"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Connectors = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _layout = require("../../../components/layout");
var _license_callout = require("../../../components/shared/license_callout");
var _source_icon = require("../../../components/shared/source_icon");
var _constants = require("../../../constants");
var _routes = require("../../../routes");
var _settings_logic = require("../settings_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Connectors = () => {
  const {
    initializeConnectors
  } = (0, _kea.useActions)(_settings_logic.SettingsLogic);
  const {
    dataLoading,
    connectors
  } = (0, _kea.useValues)(_settings_logic.SettingsLogic);
  (0, _react.useEffect)(() => {
    initializeConnectors();
  }, []);
  const availableConnectors = (0, _lodash.reject)(connectors, ({
    serviceType,
    externalConnectorServiceDescribed
  }) => serviceType === _constants.CUSTOM_SERVICE_TYPE || serviceType === _constants.EXTERNAL_SERVICE_TYPE && !externalConnectorServiceDescribed);
  const getRowActions = (configured, serviceType, supportedByLicense) => {
    const addPath = (0, _routes.getAddPath)(serviceType);
    const editPath = (0, _routes.getEditPath)(serviceType);
    const configurePath = (0, _routes.getSourcesPath)(addPath, true);
    const updateButtons = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonEmptyTo, {
      to: editPath,
      "data-test-subj": "UpdateButton"
    }, _constants.UPDATE_BUTTON)));
    const configureButton = supportedByLicense ? /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonEmptyTo, {
      to: configurePath,
      "data-test-subj": "ConfigureButton"
    }, _constants.CONFIGURE_BUTTON) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "ConfigureButton",
      disabled: true
    }, _constants.CONFIGURE_BUTTON);
    return configured ? updateButtons : configureButton;
  };
  const platinumLicenseCallout = /*#__PURE__*/_react.default.createElement(_license_callout.LicenseCallout, {
    message: _constants.PRIVATE_PLATINUM_LICENSE_CALLOUT
  });
  const connectorsList = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    responsive: false
  }, availableConnectors.map(({
    serviceType,
    name,
    configured,
    accountContextOnly,
    supportedByLicense
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: serviceType,
    "data-test-subj": "ConnectorRow"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_source_icon.SourceIcon, {
    serviceType: serviceType,
    name: name
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, name), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, accountContextOnly && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, _constants.PRIVATE_SOURCE)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, getRowActions(configured, serviceType, supportedByLicense))), accountContextOnly && !supportedByLicense && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), platinumLicenseCallout)))));
  return /*#__PURE__*/_react.default.createElement(_layout.WorkplaceSearchPageTemplate, {
    pageChrome: [_constants.NAV.SETTINGS, _constants.NAV.SETTINGS_SOURCE_PRIORITIZATION],
    pageHeader: {
      pageTitle: _constants.CONNECTORS_HEADER_TITLE,
      description: _constants.CONNECTORS_HEADER_DESCRIPTION
    },
    isLoading: dataLoading
  }, connectorsList);
};
exports.Connectors = Connectors;