"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatisticCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react_router_helpers = require("../../../shared/react_router_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatisticCard = ({
  title,
  count = 0,
  actionPath
}) => {
  const linkableCard = /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiCardTo, {
    to: actionPath || '',
    layout: "horizontal",
    title: title,
    titleSize: "xs",
    display: "plain",
    hasBorder: true,
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "l"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "default"
    }, count))
  });
  const card = /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    layout: "horizontal",
    title: title,
    titleSize: "xs",
    display: "subdued",
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "l"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, count))
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, actionPath ? linkableCard : card);
};
exports.StatisticCard = StatisticCard;