"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformServerPreAuth = exports.oauthAuthorizeRoute = exports.OAuthAuthorizeLogic = void 0;
var _kea = require("kea");
var _constants = require("../../../../../common/constants");
var _flash_messages = require("../../../shared/flash_messages");
var _http = require("../../../shared/http");
var _query_params = require("../../../shared/query_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const oauthAuthorizeRoute = exports.oauthAuthorizeRoute = '/internal/workplace_search/oauth/authorize';
const OAuthAuthorizeLogic = exports.OAuthAuthorizeLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'workplace_search', 'oauth_authorize_logic'],
  actions: {
    setServerProps: serverProps => serverProps,
    initializeOAuthPreAuth: queryString => queryString,
    allowOAuthAuthorization: null,
    denyOAuthAuthorization: null,
    setButtonNotLoading: null,
    setHasError: null
  },
  reducers: {
    dataLoading: [true, {
      setServerProps: () => false,
      setHasError: () => false
    }],
    cachedPreAuth: [{}, {
      setServerProps: (_, serverProps) => transformServerPreAuth(serverProps)
    }],
    buttonLoading: [false, {
      setButtonNotLoading: () => false,
      allowOAuthAuthorization: () => true,
      denyOAuthAuthorization: () => true
    }],
    hasError: [false, {
      setHasError: () => true
    }]
  },
  listeners: ({
    actions,
    values
  }) => ({
    initializeOAuthPreAuth: async queryString => {
      (0, _flash_messages.clearFlashMessages)();
      const {
        http
      } = _http.HttpLogic.values;
      const query = (0, _query_params.parseQueryParams)(queryString);
      try {
        const response = await http.get(oauthAuthorizeRoute, {
          query
        });
        if (response.status === 'redirect') {
          window.location.replace(response.redirect_uri);
        } else {
          actions.setServerProps(response);
        }
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
        actions.setHasError();
      }
    },
    denyOAuthAuthorization: async () => {
      const {
        http
      } = _http.HttpLogic.values;
      const {
        cachedPreAuth
      } = values;
      try {
        const response = await http.delete(oauthAuthorizeRoute, {
          body: JSON.stringify({
            client_id: cachedPreAuth.clientId,
            response_type: cachedPreAuth.responseType,
            redirect_uri: cachedPreAuth.redirectUri,
            scope: cachedPreAuth.rawScopes,
            state: cachedPreAuth.state
          }),
          headers: _constants.JSON_HEADER
        });
        window.location.replace(response.redirect_uri);
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
        actions.setButtonNotLoading();
      }
    },
    allowOAuthAuthorization: async () => {
      const {
        http
      } = _http.HttpLogic.values;
      const {
        cachedPreAuth
      } = values;
      try {
        const response = await http.post(oauthAuthorizeRoute, {
          body: JSON.stringify({
            client_id: cachedPreAuth.clientId,
            response_type: cachedPreAuth.responseType,
            redirect_uri: cachedPreAuth.redirectUri,
            scope: cachedPreAuth.rawScopes,
            state: cachedPreAuth.state
          }),
          headers: _constants.JSON_HEADER
        });
        window.location.replace(response.redirect_uri);
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
        actions.setButtonNotLoading();
      }
    }
  })
});
const transformServerPreAuth = serverProps => ({
  clientId: serverProps.client_id,
  clientName: serverProps.client_name,
  redirectUri: serverProps.redirect_uri,
  responseType: serverProps.response_type,
  rawScopes: serverProps.scope,
  scopes: serverProps.scope.split(', '),
  state: serverProps.state
});
exports.transformServerPreAuth = transformServerPreAuth;