"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OAuthAuthorize = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _flash_messages = require("../../../shared/flash_messages");
var _loading = require("../../../shared/loading");
var _constants = require("../../constants");
var _constants2 = require("./constants");
var _oauth_authorize_logic = require("./oauth_authorize_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OAuthAuthorize = () => {
  var _cachedPreAuth$redire, _cachedPreAuth$scopes;
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const {
    initializeOAuthPreAuth,
    allowOAuthAuthorization,
    denyOAuthAuthorization
  } = (0, _kea.useActions)(_oauth_authorize_logic.OAuthAuthorizeLogic);
  const {
    buttonLoading,
    dataLoading,
    cachedPreAuth,
    hasError
  } = (0, _kea.useValues)(_oauth_authorize_logic.OAuthAuthorizeLogic);
  (0, _react.useEffect)(() => {
    initializeOAuthPreAuth(search);
  }, []);
  if (dataLoading) return /*#__PURE__*/_react.default.createElement(_loading.Loading, null);
  const showHttpRedirectUriWarning = (_cachedPreAuth$redire = cachedPreAuth.redirectUri) === null || _cachedPreAuth$redire === void 0 ? void 0 : _cachedPreAuth$redire.startsWith('http:');
  const httpRedirectUriWarning = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _constants2.HTTP_REDIRECT_WARNING_MESSAGE,
    color: "danger",
    iconType: "cross"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
  const scopeDescription = scopeName => {
    if (scopeName === 'search') {
      return _constants2.SEARCH_SCOPE_DESCRIPTION;
    } else if (scopeName === 'write') {
      return _constants2.WRITE_SCOPE_DESCRIPTION;
    } else {
      return undefined;
    }
  };
  const scopeListItems = cachedPreAuth === null || cachedPreAuth === void 0 ? void 0 : (_cachedPreAuth$scopes = cachedPreAuth.scopes) === null || _cachedPreAuth$scopes === void 0 ? void 0 : _cachedPreAuth$scopes.map((scope, i) => {
    const scopeDesc = scopeDescription(scope);
    const unknownScopeDesc = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.workplaceSearch.oauthAuthorize.unknownScopeDescription",
      defaultMessage: "{unknownAction} your data",
      values: {
        unknownAction: scope
      }
    });
    return /*#__PURE__*/_react.default.createElement("li", {
      key: i,
      "data-test-subj": "ScopeDescription"
    }, scopeDesc || unknownScopeDesc);
  });
  const authorizationDetails = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.oauthAuthorize.authorizationDescription",
    defaultMessage: "Authorize {strongClientName} to use your account?",
    values: {
      strongClientName: /*#__PURE__*/_react.default.createElement("strong", null, cachedPreAuth.clientName)
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), showHttpRedirectUriWarning && httpRedirectUriWarning, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _constants2.SCOPES_LEAD_IN_MESSAGE,
    iconType: "iInCircle"
  }, /*#__PURE__*/_react.default.createElement("ul", null, scopeListItems)));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    restrictWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(_flash_messages.FlashMessages, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    style: {
      maxWidth: 500,
      margin: '40px auto'
    },
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLogo, {
    iconType: "logoWorkplaceSearch"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h1", null, _constants.WORKPLACE_SEARCH_TITLE)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _constants2.AUTHORIZATION_REQUIRED_TITLE)), !hasError && authorizationDetails, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    onClick: denyOAuthAuthorization,
    disabled: buttonLoading || hasError
  }, _constants2.DENY_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    onClick: allowOAuthAuthorization,
    disabled: buttonLoading || hasError
  }, _constants2.AUTHORIZE_BUTTON_LABEL))))));
};
exports.OAuthAuthorize = OAuthAuthorize;