"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OrgSourcesModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _group_logic = require("../group_logic");
var _groups_logic = require("../groups_logic");
var _group_manager_modal = require("./group_manager_modal");
var _sources_list = require("./sources_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MODAL_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.sourcesModalLabel', {
  defaultMessage: 'organizational content sources'
});
const OrgSourcesModal = () => {
  const {
    addGroupSource,
    selectAllSources,
    hideOrgSourcesModal,
    removeGroupSource,
    saveGroupSources
  } = (0, _kea.useActions)(_group_logic.GroupLogic);
  const {
    selectedGroupSources,
    group
  } = (0, _kea.useValues)(_group_logic.GroupLogic);
  const {
    contentSources
  } = (0, _kea.useValues)(_groups_logic.GroupsLogic);
  return /*#__PURE__*/_react.default.createElement(_group_manager_modal.GroupManagerModal, {
    label: MODAL_LABEL,
    allItems: contentSources,
    numSelected: selectedGroupSources.length,
    hideModal: hideOrgSourcesModal,
    selectAll: selectAllSources,
    saveItems: saveGroupSources
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.sourcesModalTitle', {
    defaultMessage: 'Select content sources to share with {groupName}',
    values: {
      groupName: group.name
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_sources_list.SourcesList, {
    contentSources: contentSources,
    filteredSources: selectedGroupSources,
    addFilteredSource: addGroupSource,
    removeFilteredSource: removeGroupSource
  })));
};
exports.OrgSourcesModal = OrgSourcesModal;