"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SOURCE_ASSETS_AND_OBJECTS_OBJECTS_TABLE_ITEM_LABEL = exports.SOURCE_ASSETS_AND_OBJECTS_OBJECTS_TABLE_INCLUDE_LABEL = exports.SOURCE_ASSETS_AND_OBJECTS_OBJECTS_TABLE_FILE_LABEL = exports.SOURCE_ASSETS_AND_OBJECTS_OBJECTS_TABLE_EXCLUDE_LABEL = exports.IndexingRulesTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _doc_links = require("../../../../../shared/doc_links");
var _flash_messages = require("../../../../../shared/flash_messages");
var _inline_editable_table = require("../../../../../shared/tables/inline_editable_table/inline_editable_table");
var _source_logic = require("../../source_logic");
var _synchronization_logic = require("./synchronization_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SOURCE_ASSETS_AND_OBJECTS_OBJECTS_TABLE_POLICY_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceAssetsAndObjectsObjectsTablePolicyLabel', {
  defaultMessage: 'Policy'
});
const SOURCE_ASSETS_AND_OBJECTS_OBJECTS_TABLE_PATH_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceAssetsAndObjectsObjectsTablePathLabel', {
  defaultMessage: 'Path'
});
const SOURCE_ASSETS_AND_OBJECTS_OBJECTS_TABLE_ITEM_LABEL = exports.SOURCE_ASSETS_AND_OBJECTS_OBJECTS_TABLE_ITEM_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceAssetsAndObjectsObjectsTableItemLabel', {
  defaultMessage: 'Item'
});
const SOURCE_ASSETS_AND_OBJECTS_OBJECTS_TABLE_FILE_LABEL = exports.SOURCE_ASSETS_AND_OBJECTS_OBJECTS_TABLE_FILE_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceAssetsAndObjectsObjectsTableFileLabel', {
  defaultMessage: 'File type'
});
const SOURCE_ASSETS_AND_OBJECTS_OBJECTS_TABLE_INCLUDE_LABEL = exports.SOURCE_ASSETS_AND_OBJECTS_OBJECTS_TABLE_INCLUDE_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceAssetsAndObjectsObjectsTableIncludeLabel', {
  defaultMessage: 'Include'
});
const SOURCE_ASSETS_AND_OBJECTS_OBJECTS_TABLE_EXCLUDE_LABEL = exports.SOURCE_ASSETS_AND_OBJECTS_OBJECTS_TABLE_EXCLUDE_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceAssetsAndObjectsObjectsTableExcludeLabel', {
  defaultMessage: 'Exclude'
});
const IndexingRulesTable = () => {
  const {
    contentSource
  } = (0, _kea.useValues)(_source_logic.SourceLogic);
  const indexingRulesInstanceId = 'IndexingRulesTable';
  const {
    indexingRules
  } = (0, _kea.useValues)((0, _synchronization_logic.SynchronizationLogic)({
    contentSource,
    indexingRulesInstanceId
  }));
  const {
    initAddIndexingRule,
    deleteIndexingRule,
    initSetIndexingRule,
    setIndexingRules
  } = (0, _kea.useActions)((0, _synchronization_logic.SynchronizationLogic)({
    contentSource
  }));
  const description = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "default"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceAssetsAndObjectsObjectsDescription', {
    defaultMessage: 'Add an indexing rule to customize what data is synchronized from {contentSourceName}. Everything is included by default, and documents are validated against the configured set of indexing rules starting from the top listed down.',
    values: {
      contentSourceName: contentSource.name
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.workplaceSearchSynch,
    external: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceAssetsAndObjectsSyncLearnMoreLink', {
    defaultMessage: 'Learn more about customizing your index rules.'
  })));
  const valueTypeToString = input => {
    switch (input) {
      case 'include':
        return SOURCE_ASSETS_AND_OBJECTS_OBJECTS_TABLE_INCLUDE_LABEL;
      case 'exclude':
        return SOURCE_ASSETS_AND_OBJECTS_OBJECTS_TABLE_EXCLUDE_LABEL;
      default:
        return '';
    }
  };
  const filterTypeToString = input => {
    switch (input) {
      case 'object_type':
        return SOURCE_ASSETS_AND_OBJECTS_OBJECTS_TABLE_ITEM_LABEL;
      case 'path_template':
        return SOURCE_ASSETS_AND_OBJECTS_OBJECTS_TABLE_PATH_LABEL;
      case 'file_extension':
        return SOURCE_ASSETS_AND_OBJECTS_OBJECTS_TABLE_FILE_LABEL;
      default:
        return '';
    }
  };
  const columns = [{
    editingRender: (indexingRule, onChange, {
      isInvalid,
      isLoading
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      fullWidth: true,
      value: indexingRule.valueType,
      onChange: e => onChange(e.target.value),
      disabled: isLoading,
      isInvalid: isInvalid,
      options: [{
        text: SOURCE_ASSETS_AND_OBJECTS_OBJECTS_TABLE_INCLUDE_LABEL,
        value: 'include'
      }, {
        text: SOURCE_ASSETS_AND_OBJECTS_OBJECTS_TABLE_EXCLUDE_LABEL,
        value: 'exclude'
      }]
    }),
    render: indexingRule => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, valueTypeToString(indexingRule.valueType)),
    name: SOURCE_ASSETS_AND_OBJECTS_OBJECTS_TABLE_POLICY_LABEL,
    field: 'valueType'
  }, {
    editingRender: (indexingRule, onChange, {
      isInvalid,
      isLoading
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      fullWidth: true,
      value: indexingRule.filterType,
      onChange: e => onChange(e.target.value),
      disabled: isLoading,
      isInvalid: isInvalid,
      options: [{
        text: SOURCE_ASSETS_AND_OBJECTS_OBJECTS_TABLE_ITEM_LABEL,
        value: 'object_type'
      }, {
        text: SOURCE_ASSETS_AND_OBJECTS_OBJECTS_TABLE_PATH_LABEL,
        value: 'path_template'
      }, {
        text: SOURCE_ASSETS_AND_OBJECTS_OBJECTS_TABLE_FILE_LABEL,
        value: 'file_extension'
      }]
    }),
    render: indexingRule => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, filterTypeToString(indexingRule.filterType)),
    name: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceAssetsAndObjectsObjectsTableRuleLabel', {
      defaultMessage: 'Rule'
    }),
    field: 'filterType'
  }, {
    editingRender: (indexingRule, onChange, {
      isInvalid,
      isLoading
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      fullWidth: true,
      value: indexingRule.value,
      onChange: e => onChange(e.target.value),
      disabled: isLoading,
      isInvalid: isInvalid
    }))),
    render: indexingRule => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, indexingRule.value),
    name: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceAssetsAndObjectsObjectsTableValueLabel', {
      defaultMessage: 'Value'
    }),
    field: 'value'
  }];
  return /*#__PURE__*/_react.default.createElement(_inline_editable_table.InlineEditableTable, {
    addButtonText: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceAssetsAndObjectsAddRuleLabel', {
      defaultMessage: 'Add indexing rule'
    }),
    columns: columns,
    defaultItem: {
      valueType: 'include',
      filterType: 'object_type'
    },
    description: description,
    instanceId: indexingRulesInstanceId,
    items: indexingRules,
    onAdd: newRule => {
      initAddIndexingRule(newRule);
      (0, _flash_messages.clearFlashMessages)();
    },
    onDelete: rule => {
      deleteIndexingRule(rule);
      (0, _flash_messages.clearFlashMessages)();
    },
    onUpdate: rule => {
      initSetIndexingRule(rule);
      (0, _flash_messages.clearFlashMessages)();
    },
    onReorder: newIndexingRules => {
      setIndexingRules(newIndexingRules);
      (0, _flash_messages.clearFlashMessages)();
    },
    title: "",
    bottomRows: [/*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.indexingRulesTable.includeEverythingMessage', {
      defaultMessage: 'Include everything else from this source'
    }))],
    canRemoveLastItem: true,
    showRowIndex: true
  });
};
exports.IndexingRulesTable = IndexingRulesTable;