"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SaveConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _licensing = require("../../../../../shared/licensing");
var _api_key = require("../../../../components/shared/api_key");
var _constants = require("../../../../constants");
var _add_external_connector = require("./add_external_connector");
var _add_source_logic = require("./add_source_logic");
var _config_docs_links = require("./config_docs_links");
var _constants2 = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const clientIdSecretFields = [{
  key: 'client_id',
  label: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.saveConfig.clientIDLabel', {
    defaultMessage: 'Client ID'
  })
}, {
  key: 'client_secret',
  label: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.saveConfig.clientSecretLabel', {
    defaultMessage: 'Client Secret'
  })
}];
const baseUrlFields = [{
  key: 'base_url',
  label: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.saveConfig.baseUrlLabel', {
    defaultMessage: 'Base URL'
  })
}];
const getInternalConnectorConfigurableFields = (needsClientIdSecret, needsBaseUrl) => {
  return [...(needsClientIdSecret ? clientIdSecretFields : []), ...(needsBaseUrl ? baseUrlFields : [])];
};
const SaveConfig = ({
  name,
  configuration,
  advanceStep,
  goBackStep,
  onDeleteConfig,
  header
}) => {
  const {
    documentationUrl,
    applicationPortalUrl,
    applicationLinkTitle
  } = configuration;
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const {
    setConfiguredField
  } = (0, _kea.useActions)(_add_source_logic.AddSourceLogic);
  const {
    sourceConfigData,
    buttonLoading,
    configuredFields
  } = (0, _kea.useValues)(_add_source_logic.AddSourceLogic);
  const {
    accountContextOnly,
    serviceType,
    configurableFields = []
  } = sourceConfigData;
  const isPublicKey = configuredFields.public_key && configuredFields.consumer_key;
  const needsClientIdSecret = !isPublicKey;
  const formFields = serviceType === 'external' ? configurableFields : getInternalConnectorConfigurableFields(needsClientIdSecret, configuration.needsBaseUrl);
  const handleFormSubmission = e => {
    e.preventDefault();
    advanceStep();
  };
  const saveButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    isLoading: buttonLoading,
    type: "submit"
  }, _constants2.OAUTH_SAVE_CONFIG_BUTTON);
  const deleteButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    fill: true,
    disabled: buttonLoading,
    onClick: onDeleteConfig
  }, _constants.REMOVE_BUTTON);
  const backButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: goBackStep
  }, _constants2.OAUTH_BACK_BUTTON);
  const showSaveButton = hasPlatinumLicense || !accountContextOnly;
  const formActions = /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    gutterSize: "m",
    responsive: false
  }, showSaveButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, saveButton), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, goBackStep && backButton, onDeleteConfig && deleteButton)));
  const oauthStep = {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.saveConfig.oauthStep1', {
      defaultMessage: "Create an OAuth app in your organization's {sourceName} account",
      values: {
        sourceName: name
      }
    }),
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      direction: "column",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_config_docs_links.ConfigDocsLinks, {
      name: name,
      documentationUrl: documentationUrl,
      applicationPortalUrl: applicationPortalUrl,
      applicationLinkTitle: applicationLinkTitle
    }), isPublicKey && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      justifyContent: "flexStart",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_api_key.ApiKey, {
      label: _constants.PUBLIC_KEY_LABEL,
      apiKey: configuredFields.public_key
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_api_key.ApiKey, {
      label: _constants.CONSUMER_KEY_LABEL,
      apiKey: configuredFields.consumer_key
    })))))
  };
  const configurationStep = {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.saveConfig.oauthStep2', {
      defaultMessage: 'Provide the appropriate configuration information'
    }),
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, serviceType === 'external' && /*#__PURE__*/_react.default.createElement(_add_external_connector.ExternalConnectorFormFields, null), formFields.map(({
      key,
      label
    }, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      key: index,
      label: label
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: configuredFields[key],
      required: true,
      type: "text",
      autoComplete: "off",
      onChange: e => setConfiguredField(key, e.target.value),
      name: key
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), formActions)))
  };
  const configSteps = serviceType === 'external' ? [configurationStep] : [oauthStep, configurationStep];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, header, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), serviceType === 'external' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_add_external_connector.ExternalConnectorDocumentation, {
    name: name,
    documentationUrl: documentationUrl
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement("form", {
    onSubmit: handleFormSubmission
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: configSteps,
    className: "adding-a-source__config-steps"
  })));
};
exports.SaveConfig = SaveConfig;