"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigurationIntro = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react_router_helpers = require("../../../../../shared/react_router_helpers");
var _connection_illustration = _interopRequireDefault(require("../../../../assets/connection_illustration.svg"));
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfigurationIntro = ({
  name,
  advanceStepTo,
  header
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, header, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "flexStart",
  alignItems: "flexStart",
  direction: "row",
  responsive: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  color: "subdued",
  paddingSize: "none"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "flexStart",
  alignItems: "stretch",
  direction: "row",
  gutterSize: "xl",
  responsive: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement("div", {
  className: "adding-a-source__intro-image"
}, /*#__PURE__*/_react.default.createElement("img", {
  src: _connection_illustration.default,
  alt: _constants.CONFIG_INTRO_ALT_TEXT
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  className: "adding-a-source__intro-steps"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xl"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "l"
}, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.configIntro.steps.title', {
  defaultMessage: 'How to add {name}',
  values: {
    name
  }
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: "subdued",
  grow: false
}, /*#__PURE__*/_react.default.createElement("p", null, _constants.CONFIG_INTRO_STEPS_TEXT)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "flexStart",
  justifyContent: "flexStart",
  responsive: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement("div", {
  className: "adding-a-source__intro-step"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xs"
}, /*#__PURE__*/_react.default.createElement("h3", null, _constants.CONFIG_INTRO_STEP1_HEADING)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "m",
  grow: false
}, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.workplaceSearch.contentSource.configIntro.step1.title",
  defaultMessage: "Configure an OAuth application {badge}",
  values: {
    badge: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "#6DCCB1"
    }, _constants.CONFIG_INTRO_STEP1_BADGE)
  }
})), /*#__PURE__*/_react.default.createElement("p", null, _constants.CONFIG_INTRO_STEP1_TEXT))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "flexStart",
  justifyContent: "flexStart",
  responsive: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement("div", {
  className: "adding-a-source__intro-step"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xs"
}, /*#__PURE__*/_react.default.createElement("h4", null, _constants.CONFIG_INTRO_STEP2_HEADING)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "m",
  grow: false
}, /*#__PURE__*/_react.default.createElement("h4", null, _constants.CONFIG_INTRO_STEP2_TITLE), /*#__PURE__*/_react.default.createElement("p", null, _constants.CONFIG_INTRO_STEP2_TEXT))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
  color: "primary",
  "data-test-subj": "ConfigureStepButton",
  fill: true,
  to: advanceStepTo
}, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.configIntro.configure.button', {
  defaultMessage: 'Configure {name}',
  values: {
    name
  }
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xl"
})))))))));
exports.ConfigurationIntro = ConfigurationIntro;