"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigDocsLinks = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfigDocsLinks = ({
  name,
  documentationUrl,
  applicationPortalUrl,
  applicationLinkTitle,
  discussUrl
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "flexStart",
  responsive: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  flush: "left",
  iconType: "popout",
  href: documentationUrl,
  target: "_blank"
}, _constants.DOCUMENTATION_LINK_TITLE)), applicationPortalUrl && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  flush: "left",
  iconType: "popout",
  href: applicationPortalUrl,
  target: "_blank"
}, applicationLinkTitle || _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.configDocs.applicationPortal.button', {
  defaultMessage: '{name} Application Portal',
  values: {
    name
  }
}))), discussUrl && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  flush: "left",
  iconType: "popout",
  target: "_blank",
  href: discussUrl
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.workplaceSearch.contentSource.configDocs.discuss.buttonLabel",
  defaultMessage: "Questions? Discuss here."
}))));
exports.ConfigDocsLinks = ConfigDocsLinks;