"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSourcesPath = exports.getReindexJobRoute = exports.getGroupSourcePrioritizationPath = exports.getGroupPath = exports.getEditPath = exports.getContentSourcePath = exports.getAddPath = exports.USERS_AND_ROLES_PATH = exports.SYNC_FREQUENCY_PATH = exports.SOURCE_SYNCHRONIZATION_PATH = exports.SOURCE_SETTINGS_PATH = exports.SOURCE_SCHEMAS_PATH = exports.SOURCE_DISPLAY_SETTINGS_PATH = exports.SOURCE_DETAILS_PATH = exports.SOURCE_CONTENT_PATH = exports.SOURCE_ADDED_PATH = exports.SOURCES_PATH = exports.SETUP_GUIDE_PATH = exports.SECURITY_PATH = exports.SEARCH_AUTHORIZE_PATH = exports.REINDEX_JOB_PATH = exports.PRIVATE_SOURCES_PATH = exports.PERSONAL_SETTINGS_PATH = exports.PERSONAL_PATH = exports.ORG_SETTINGS_PATH = exports.ORG_SETTINGS_OAUTH_APPLICATION_PATH = exports.ORG_SETTINGS_CUSTOMIZE_PATH = exports.ORG_SETTINGS_CONNECTORS_PATH = exports.OLD_OBJECTS_AND_ASSETS_PATH = exports.OAUTH_AUTHORIZE_PATH = exports.NOT_FOUND_PATH = exports.LOGOUT_ROUTE = exports.LEAVE_FEEDBACK_URL = exports.LEAVE_FEEDBACK_EMAIL = exports.GROUP_SOURCE_PRIORITIZATION_PATH = exports.GROUP_PATH = exports.GROUPS_PATH = exports.DISPLAY_SETTINGS_SEARCH_RESULT_PATH = exports.DISPLAY_SETTINGS_RESULT_DETAIL_PATH = exports.BLOCKED_TIME_WINDOWS_PATH = exports.ASSETS_AND_OBJECTS_PATH = exports.API_KEYS_PATH = exports.ADD_SOURCE_PATH = exports.ADD_EXTERNAL_PATH = exports.ADD_CUSTOM_PATH = void 0;
var _reactRouterDom = require("react-router-dom");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SETUP_GUIDE_PATH = exports.SETUP_GUIDE_PATH = '/setup_guide';
const NOT_FOUND_PATH = exports.NOT_FOUND_PATH = '/404';
const LOGOUT_ROUTE = exports.LOGOUT_ROUTE = '/logout';
const LEAVE_FEEDBACK_EMAIL = exports.LEAVE_FEEDBACK_EMAIL = 'support@elastic.co';
const LEAVE_FEEDBACK_URL = exports.LEAVE_FEEDBACK_URL = `mailto:${LEAVE_FEEDBACK_EMAIL}?Subject=Elastic%20Workplace%20Search%20Feedback`;
const PERSONAL_PATH = exports.PERSONAL_PATH = '/p';
const OAUTH_AUTHORIZE_PATH = exports.OAUTH_AUTHORIZE_PATH = `${PERSONAL_PATH}/oauth/authorize`;
const SEARCH_AUTHORIZE_PATH = exports.SEARCH_AUTHORIZE_PATH = `${PERSONAL_PATH}/authorize_search`;
const USERS_AND_ROLES_PATH = exports.USERS_AND_ROLES_PATH = '/users_and_roles';
const API_KEYS_PATH = exports.API_KEYS_PATH = '/api_keys';
const SECURITY_PATH = exports.SECURITY_PATH = '/security';
const GROUPS_PATH = exports.GROUPS_PATH = '/groups';
const GROUP_PATH = exports.GROUP_PATH = `${GROUPS_PATH}/:groupId`;
const GROUP_SOURCE_PRIORITIZATION_PATH = exports.GROUP_SOURCE_PRIORITIZATION_PATH = `${GROUPS_PATH}/:groupId/source_prioritization`;
const SOURCES_PATH = exports.SOURCES_PATH = '/sources';
const PRIVATE_SOURCES_PATH = exports.PRIVATE_SOURCES_PATH = `${PERSONAL_PATH}${SOURCES_PATH}`;
const SOURCE_ADDED_PATH = exports.SOURCE_ADDED_PATH = `${SOURCES_PATH}/added`;
const ADD_SOURCE_PATH = exports.ADD_SOURCE_PATH = `${SOURCES_PATH}/add`;
const ADD_EXTERNAL_PATH = exports.ADD_EXTERNAL_PATH = `${SOURCES_PATH}/add/external`;
const ADD_CUSTOM_PATH = exports.ADD_CUSTOM_PATH = `${SOURCES_PATH}/add/custom`;
const PERSONAL_SETTINGS_PATH = exports.PERSONAL_SETTINGS_PATH = `${PERSONAL_PATH}/settings`;
const SOURCE_DETAILS_PATH = exports.SOURCE_DETAILS_PATH = `${SOURCES_PATH}/:sourceId`;
const SOURCE_CONTENT_PATH = exports.SOURCE_CONTENT_PATH = `${SOURCES_PATH}/:sourceId/content`;
const SOURCE_SCHEMAS_PATH = exports.SOURCE_SCHEMAS_PATH = `${SOURCES_PATH}/:sourceId/schemas`;
const SOURCE_DISPLAY_SETTINGS_PATH = exports.SOURCE_DISPLAY_SETTINGS_PATH = `${SOURCES_PATH}/:sourceId/display_settings`;
const SOURCE_SYNCHRONIZATION_PATH = exports.SOURCE_SYNCHRONIZATION_PATH = `${SOURCES_PATH}/:sourceId/synchronization`;
const SOURCE_SETTINGS_PATH = exports.SOURCE_SETTINGS_PATH = `${SOURCES_PATH}/:sourceId/settings`;
const REINDEX_JOB_PATH = exports.REINDEX_JOB_PATH = `${SOURCE_SCHEMAS_PATH}/:activeReindexJobId`;
const DISPLAY_SETTINGS_SEARCH_RESULT_PATH = exports.DISPLAY_SETTINGS_SEARCH_RESULT_PATH = `${SOURCE_DISPLAY_SETTINGS_PATH}/`;
const DISPLAY_SETTINGS_RESULT_DETAIL_PATH = exports.DISPLAY_SETTINGS_RESULT_DETAIL_PATH = `${SOURCE_DISPLAY_SETTINGS_PATH}/result_detail`;
const SYNC_FREQUENCY_PATH = exports.SYNC_FREQUENCY_PATH = `${SOURCE_SYNCHRONIZATION_PATH}/frequency`;
const BLOCKED_TIME_WINDOWS_PATH = exports.BLOCKED_TIME_WINDOWS_PATH = `${SOURCE_SYNCHRONIZATION_PATH}/frequency/blocked_windows`;
const OLD_OBJECTS_AND_ASSETS_PATH = exports.OLD_OBJECTS_AND_ASSETS_PATH = `${SOURCE_SYNCHRONIZATION_PATH}/objects_and_assets`;
const ASSETS_AND_OBJECTS_PATH = exports.ASSETS_AND_OBJECTS_PATH = `${SOURCE_SYNCHRONIZATION_PATH}/assets_and_objects`;
const ORG_SETTINGS_PATH = exports.ORG_SETTINGS_PATH = '/settings';
const ORG_SETTINGS_CUSTOMIZE_PATH = exports.ORG_SETTINGS_CUSTOMIZE_PATH = `${ORG_SETTINGS_PATH}/customize`;
const ORG_SETTINGS_CONNECTORS_PATH = exports.ORG_SETTINGS_CONNECTORS_PATH = `${ORG_SETTINGS_PATH}/connectors`;
const ORG_SETTINGS_OAUTH_APPLICATION_PATH = exports.ORG_SETTINGS_OAUTH_APPLICATION_PATH = `${ORG_SETTINGS_PATH}/oauth`;
const getContentSourcePath = (path, sourceId, isOrganization) => (0, _reactRouterDom.generatePath)(isOrganization ? path : `${PERSONAL_PATH}${path}`, {
  sourceId
});
exports.getContentSourcePath = getContentSourcePath;
const getGroupPath = groupId => (0, _reactRouterDom.generatePath)(GROUP_PATH, {
  groupId
});
exports.getGroupPath = getGroupPath;
const getGroupSourcePrioritizationPath = groupId => `${GROUPS_PATH}/${groupId}/source_prioritization`;
exports.getGroupSourcePrioritizationPath = getGroupSourcePrioritizationPath;
const getSourcesPath = (path, isOrganization) => isOrganization ? path : `${PERSONAL_PATH}${path}`;
exports.getSourcesPath = getSourcesPath;
const getReindexJobRoute = (sourceId, activeReindexJobId, isOrganization) => getSourcesPath((0, _reactRouterDom.generatePath)(REINDEX_JOB_PATH, {
  sourceId,
  activeReindexJobId
}), isOrganization);
exports.getReindexJobRoute = getReindexJobRoute;
const getAddPath = (serviceType, baseServiceType) => {
  const baseServiceTypePath = baseServiceType ? `${baseServiceType}/${serviceType}` : `${serviceType}`;
  return `${SOURCES_PATH}/add/${baseServiceTypePath}`;
};

// TODO this should handle base service type once we are getting it back from registered external connectors
exports.getAddPath = getAddPath;
const getEditPath = serviceType => `${ORG_SETTINGS_CONNECTORS_PATH}/${serviceType}/edit`;
exports.getEditPath = getEditPath;