"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoleSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _role_option_label = require("./role_option_label");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RoleSelector = ({
  label,
  roleType,
  roleOptions,
  onChange
}) => {
  const options = roleOptions.map(({
    id,
    description,
    disabled
  }) => ({
    id,
    label: /*#__PURE__*/_react.default.createElement(_role_option_label.RoleOptionLabel, {
      label: id,
      description: description
    }),
    disabled
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    options: options,
    idSelected: roleOptions.filter(r => r.id === roleType)[0].id,
    onChange: id => {
      onChange(id);
    },
    legend: {
      children: /*#__PURE__*/_react.default.createElement("span", null, label)
    }
  }));
};
exports.RoleSelector = RoleSelector;