"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoleMappingFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _actions = require("../constants/actions");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RoleMappingFlyout = ({
  children,
  isNew,
  disabled,
  formLoading,
  closeUsersAndRolesFlyout,
  handleSaveMapping
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
  ownFocus: true,
  onClose: closeUsersAndRolesFlyout,
  size: "s",
  "aria-labelledby": "flyoutLargeTitle"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
  hasBorder: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "m"
}, /*#__PURE__*/_react.default.createElement("h2", {
  id: "flyoutLargeTitle",
  "data-test-subj": "FlyoutTitle"
}, isNew ? _constants.ROLE_MAPPING_FLYOUT_CREATE_TITLE : _constants.ROLE_MAPPING_FLYOUT_UPDATE_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs"
}, /*#__PURE__*/_react.default.createElement("p", null, _constants.ROLE_MAPPING_FLYOUT_DESCRIPTION))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, children, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "spaceBetween"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  onClick: closeUsersAndRolesFlyout
}, _actions.CANCEL_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  disabled: disabled,
  isLoading: formLoading,
  onClick: handleSaveMapping,
  fill: true,
  "data-test-subj": "FlyoutButton"
}, isNew ? _constants.ROLE_MAPPING_FLYOUT_CREATE_BUTTON : _constants.ROLE_MAPPING_FLYOUT_UPDATE_BUTTON))))));
exports.RoleMappingFlyout = RoleMappingFlyout;