"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttributeSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const attributeValueExamples = {
  username: 'elastic,*_system',
  email: 'user@example.com,*@example.org',
  metadata: '{"_reserved": true}'
};
const AttributeSelector = ({
  attributeName,
  attributeValue = '',
  attributeValueInvalid,
  attributes,
  elasticsearchRoles,
  disabled,
  handleAttributeSelectorChange,
  handleAttributeValueChange
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "AttributeSelector"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants.EXTERNAL_ATTRIBUTE_LABEL,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    name: "external-attribute",
    "data-test-subj": "ExternalAttributeSelect",
    value: attributeName,
    required: true,
    options: attributes.map(attribute => ({
      value: attribute,
      text: attribute
    })),
    onChange: e => {
      handleAttributeSelectorChange(e.target.value, elasticsearchRoles[0]);
    },
    fullWidth: true,
    disabled: disabled
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants.ATTRIBUTE_VALUE_LABEL,
    fullWidth: true,
    helpText: attributeValueInvalid && _constants.REQUIRED_LABEL
  }, attributeName === 'role' ? /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    value: attributeValue,
    name: "elasticsearch-role",
    "data-test-subj": "ElasticsearchRoleSelect",
    required: true,
    options: elasticsearchRoles.map(elasticsearchRole => ({
      value: elasticsearchRole,
      text: elasticsearchRole
    })),
    onChange: e => {
      handleAttributeValueChange(e.target.value);
    },
    fullWidth: true,
    disabled: disabled
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: attributeValue,
    name: "attribute-value",
    placeholder: attributeValueExamples[attributeName],
    onChange: e => {
      handleAttributeValueChange(e.target.value);
    },
    fullWidth: true,
    disabled: disabled
  })));
};
exports.AttributeSelector = AttributeSelector;