"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_EXPIRES_VALUE = exports.BasicSetupForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_EXPIRES_VALUE = exports.DEFAULT_EXPIRES_VALUE = '60';
const BasicSetupForm = ({
  isLoading,
  name,
  user,
  expires,
  onChangeName,
  onChangeExpires
}) => {
  let expirationDate;
  if (expires) {
    expirationDate = new Date();
    expirationDate.setDate(expirationDate.getDate() + parseInt(expires, 10));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: !name,
    helpText: _i18n.i18n.translate('xpack.enterpriseSearch.apiKey.nameFieldHelpText', {
      defaultMessage: 'A good name makes it clear what your API key does.'
    }),
    label: _i18n.i18n.translate('xpack.enterpriseSearch.apiKey.nameFieldLabel', {
      defaultMessage: 'Name'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    isLoading: isLoading,
    value: name,
    onChange: e => onChangeName(e.currentTarget.value),
    "data-test-subj": "create-api-key-name"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: _i18n.i18n.translate('xpack.enterpriseSearch.apiKey.userFieldHelpText', {
      defaultMessage: 'ID of the user creating the API key.'
    }),
    label: _i18n.i18n.translate('xpack.enterpriseSearch.apiKey.userFieldLabel', {
      defaultMessage: 'User'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "enterpriseSearchBasicSetupFormFieldText",
    fullWidth: true,
    disabled: true,
    value: user
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      justifyContent: "flexEnd",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warning",
      size: "s",
      color: "subdued"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.apiKey.expiresFieldHelpText', {
      defaultMessage: 'API keys should be rotated regularly.'
    })))),
    label: _i18n.i18n.translate('xpack.enterpriseSearch.apiKey.expiresFieldLabel', {
      defaultMessage: 'Expires'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    options: [{
      id: 'never',
      label: _i18n.i18n.translate('xpack.enterpriseSearch.apiKey.expiresField.neverLabel', {
        defaultMessage: 'Never'
      }),
      'data-test-subj': 'create-api-key-expires-never-radio'
    }, {
      id: 'days',
      label: _i18n.i18n.translate('xpack.enterpriseSearch.apiKey.expiresField.daysLabel', {
        defaultMessage: 'in days'
      }),
      'data-test-subj': 'create-api-key-expires-days-radio'
    }],
    name: "create-api-key-expires-group",
    idSelected: expires === null ? 'never' : 'days',
    onChange: id => onChangeExpires(id === 'never' ? null : DEFAULT_EXPIRES_VALUE),
    "data-test-subj": "create-api-key-expires-radio"
  })), expires !== null && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.apiKey.expiresHelpText",
      defaultMessage: "This API Key will expire on {expirationDate}",
      values: {
        expirationDate: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
          year: "numeric",
          month: "long",
          day: "numeric",
          value: expirationDate
        }))
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    disabled: isLoading,
    append: _i18n.i18n.translate('xpack.enterpriseSearch.apiKey.expiresFieldUnit', {
      defaultMessage: 'days'
    }),
    placeholder: "1",
    defaultValue: expires,
    min: 1,
    onChange: e => onChangeExpires(e.currentTarget.value),
    "data-test-subj": "create-api-key-expires-days-number-field"
  })));
};
exports.BasicSetupForm = BasicSetupForm;