"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationsProductCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _search_applications_logo = _interopRequireDefault(require("../../assets/search_applications_logo.svg"));
var _product_card = require("../product_card");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchApplicationsProductCard = ({
  hasBorder = true,
  hasShadow = true
}) => /*#__PURE__*/_react.default.createElement(_product_card.ProductCard, {
  hasBorder: hasBorder,
  hasShadow: hasShadow,
  cta: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.productCardCTA', {
    defaultMessage: 'Explore Search Applications'
  }),
  description: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.description', {
    defaultMessage: 'Search Applications help make your Elasticsearch data easily searchable for end users'
  }),
  emptyCta: true,
  icon: _search_applications_logo.default,
  iconSize: "l",
  name: _constants.APPLICATIONS_PLUGIN.NAV_TITLE,
  productId: _constants.APPLICATIONS_PLUGIN.ID,
  url: _constants.APPLICATIONS_PLUGIN.URL
});
exports.SearchApplicationsProductCard = SearchApplicationsProductCard;