"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnterpriseSearchOverviewHeaderActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnterpriseSearchOverviewHeaderActions = () => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  // TODO change it with actual value
  // TODO make this conditional only for users on cloud, as on-prem users will not have a deployment id to show.
  const clientId = 'fgdshjafghj13eshfdjag718yfhjdskf';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => setIsPopoverOpen(!isPopoverOpen)
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "info"
    }), "\xA0", _i18n.i18n.translate('xpack.enterpriseSearch.overview.deploymentDetails', {
      defaultMessage: 'Deployment details'
    })),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, _i18n.i18n.translate('xpack.enterpriseSearch.overview.deploymentDetails', {
    defaultMessage: 'Deployment details'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.overview.deploymentDetails.description', {
    defaultMessage: 'Send data to Elastic from your applications by referencing your deployment and Elasticsearch information.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.overview.deploymentDetails.clientIdLabel', {
      defaultMessage: 'Client ID'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    readOnly: true,
    value: clientId,
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    beforeMessage: _i18n.i18n.translate('xpack.enterpriseSearch.overview.deploymentDetails.copyToClipboard', {
      defaultMessage: 'Copy to clipboard'
    }),
    afterMessage: _i18n.i18n.translate('xpack.enterpriseSearch.overview.deploymentDetails.copiedToClipboard', {
      defaultMessage: 'Copied Client ID to clipboard'
    }),
    textToCopy: clientId
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.overview.deploymentDetails.copyButtonAriaLabel', {
      defaultMessage: 'Copy to clipboard'
    }),
    onClick: copy,
    iconType: "copyClipboard",
    color: "primary",
    display: "base",
    size: "s"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, null, _i18n.i18n.translate('xpack.enterpriseSearch.overview.createAndManageButton', {
    defaultMessage: 'Create and manage API keys'
  })))));
};
exports.EnterpriseSearchOverviewHeaderActions = EnterpriseSearchOverviewHeaderActions;