"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteInferencePipelineButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DELETE_PIPELINE_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.action.delete', {
  defaultMessage: 'Delete pipeline'
});
const DeleteInferencePipelineButton = props => {
  if (props.pipeline.pipelineReferences.length > 1) {
    const indexReferences = props.pipeline.pipelineReferences.map(mlPipeline => mlPipeline.replace('@ml-inference', '')).join(', ');
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.action.delete.disabledDescription', {
        defaultMessage: 'This inference pipeline cannot be deleted because it is used in multiple pipelines [{indexReferences}]. You must detach this pipeline from all but one ingest pipeline before it can be deleted.',
        values: {
          indexReferences
        }
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-telemetry-id": props['data-telemetry-id'],
      size: "s",
      flush: "both",
      iconType: "trash",
      color: "text",
      disabled: true
    }, DELETE_PIPELINE_LABEL));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": props['data-telemetry-id'],
    size: "s",
    flush: "both",
    iconType: "trash",
    color: "text",
    onClick: props.onClick
  }, DELETE_PIPELINE_LABEL);
};
exports.DeleteInferencePipelineButton = DeleteInferencePipelineButton;