"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoConnectorRecord = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _api = require("../../../../../../common/types/api");
var _recreate_crawler_connector_api_logic = require("../../../api/crawler/recreate_crawler_connector_api_logic");
var _delete_index_modal = require("../../search_indices/delete_index_modal");
var _indices_logic = require("../../search_indices/indices_logic");
var _index_view_logic = require("../index_view_logic");
var _no_connector_record_logic = require("./no_connector_record_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoConnectorRecord = () => {
  const {
    indexName
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    isDeleteLoading
  } = (0, _kea.useValues)(_indices_logic.IndicesLogic);
  const {
    openDeleteModal
  } = (0, _kea.useActions)(_indices_logic.IndicesLogic);
  const {
    makeRequest
  } = (0, _kea.useActions)(_recreate_crawler_connector_api_logic.RecreateCrawlerConnectorApiLogic);
  const {
    status
  } = (0, _kea.useValues)(_recreate_crawler_connector_api_logic.RecreateCrawlerConnectorApiLogic);
  _no_connector_record_logic.NoConnectorRecordLogic.mount();
  const buttonsDisabled = status === _api.Status.LOADING || isDeleteLoading;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_delete_index_modal.DeleteIndexModal, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
    iconType: "warning",
    color: "danger",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.noCrawlerConnectorFound.title', {
      defaultMessage: "This index's connector configuration has been removed"
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.noCrawlerConnectorFound.description', {
      defaultMessage: 'We could not find a connector configuration for this crawler index. The record should be recreated, or the index should be deleted.'
    })),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "danger",
      disabled: buttonsDisabled,
      isLoading: status === _api.Status.LOADING,
      onClick: () => makeRequest({
        indexName
      })
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.noCrawlerConnectorFound.recreateConnectorRecord', {
      defaultMessage: 'Recreate connector record'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "danger",
      disabled: buttonsDisabled,
      isLoading: isDeleteLoading,
      fill: true,
      onClick: () => openDeleteModal(indexName)
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.noCrawlerConnectorFound.deleteIndex', {
      defaultMessage: 'Delete index'
    }))]
  }));
};
exports.NoConnectorRecord = NoConnectorRecord;