"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditExtractionRule = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _extraction_rules = require("../../../../../../../../common/types/extraction_rules");
var _doc_links = require("../../../../../../shared/doc_links");
var _content_fields_panel = require("./content_fields_panel");
var _edit_field_rule_flyout = require("./edit_field_rule_flyout");
var _extraction_rules_logic = require("./extraction_rules_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var UrlState = /*#__PURE__*/function (UrlState) {
  UrlState["ALL"] = "all";
  UrlState["SPECIFIC"] = "specific";
  return UrlState;
}(UrlState || {});
const getReadableExtractionFilter = rule => {
  switch (rule) {
    case _extraction_rules.ExtractionFilter.BEGINS:
      return _i18n.i18n.translate('xpack.enterpriseSearch.crawler.extractionRulesExtractionFilter.beginsWithLabel', {
        defaultMessage: 'Begins with'
      });
    case _extraction_rules.ExtractionFilter.ENDS:
      return _i18n.i18n.translate('xpack.enterpriseSearch.crawler.extractionRulesExtractionFilter.endsWithLabel', {
        defaultMessage: 'Ends with'
      });
    case _extraction_rules.ExtractionFilter.CONTAINS:
      return _i18n.i18n.translate('xpack.enterpriseSearch.crawler.extractionRulesExtractionFilter.containsLabel', {
        defaultMessage: 'Contains'
      });
    case _extraction_rules.ExtractionFilter.REGEX:
      return _i18n.i18n.translate('xpack.enterpriseSearch.crawler.extractionRulesExtractionFilter.regexLabel', {
        defaultMessage: 'Regex'
      });
  }
};
const extractionFilterOptions = [_extraction_rules.ExtractionFilter.BEGINS, _extraction_rules.ExtractionFilter.ENDS, _extraction_rules.ExtractionFilter.CONTAINS, _extraction_rules.ExtractionFilter.REGEX].map(ruleOption => ({
  text: getReadableExtractionFilter(ruleOption),
  value: ruleOption
}));
const EditExtractionRule = ({
  cancelEditing,
  extractionRule,
  isNewRule,
  saveRule
}) => {
  const {
    closeEditRuleFlyout,
    openEditRuleFlyout
  } = (0, _kea.useActions)(_extraction_rules_logic.ExtractionRulesLogic);
  const {
    fieldRuleFlyoutVisible,
    fieldRuleToEdit,
    fieldRuleToEditIsNew
  } = (0, _kea.useValues)(_extraction_rules_logic.ExtractionRulesLogic);
  const [urlToggle, setUrlToggle] = (0, _react.useState)(UrlState.ALL);
  const {
    control,
    formState,
    getValues,
    handleSubmit,
    reset,
    setValue
  } = (0, _reactHookForm.useForm)({
    defaultValues: extractionRule !== null && extractionRule !== void 0 ? extractionRule : {
      description: '',
      rules: [],
      url_filters: []
    },
    mode: 'all'
  });
  const {
    append: appendUrlFilter,
    fields: urlFiltersFields,
    remove: removeUrlFilter
  } = (0, _reactHookForm.useFieldArray)({
    control,
    name: 'url_filters'
  });
  const {
    append: appendRule,
    fields: rulesFields,
    remove: removeRule,
    update: updateRule
  } = (0, _reactHookForm.useFieldArray)({
    control,
    name: 'rules'
  });
  (0, _react.useEffect)(() => {
    reset(extractionRule !== null && extractionRule !== void 0 ? extractionRule : {
      description: '',
      rules: [],
      url_filters: []
    });
    if (extractionRule) {
      setUrlToggle(extractionRule.url_filters.length === 0 ? UrlState.ALL : UrlState.SPECIFIC);
    } else {
      setUrlToggle(UrlState.ALL);
    }
  }, [extractionRule]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, isNewRule ? _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.addRule.title', {
    defaultMessage: 'Create a content extraction rule'
  }) : _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editRule.title', {
    defaultMessage: 'Edit content extraction rule'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    onSubmit: handleSubmit(saveRule)
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: "description",
    rules: {
      validate: rule => {
        if (!(rule !== null && rule !== void 0 && rule.trim())) {
          return _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editRule.descriptionError', {
            defaultMessage: 'A description is required for a content extraction rule'
          });
        }
      }
    },
    render: ({
      field,
      fieldState
    }) => {
      var _fieldState$error, _field$value;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        error: (_fieldState$error = fieldState.error) === null || _fieldState$error === void 0 ? void 0 : _fieldState$error.message,
        isInvalid: !!(fieldState.error && fieldState.isTouched),
        helpText: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editRule.helpText', {
          defaultMessage: 'Help others understand what data this rule will extract'
        }),
        label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editRule.descriptionLabel', {
          defaultMessage: 'Rule description'
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        "data-telemetry-id": "entSearchContent-crawler-domainDetail-extractionRules-editRuleDescription",
        isInvalid: !!(fieldState.error && fieldState.isTouched),
        value: (_field$value = field.value) !== null && _field$value !== void 0 ? _field$value : '',
        onBlur: field.onBlur,
        onChange: field.onChange,
        inputRef: field.ref,
        placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editRule.placeholderLabel', {
          defaultMessage: 'e.g. "Documentation Titles"'
        })
      }));
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editRule.urlLabel', {
      defaultMessage: 'URL'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    "data-telemetry-id": "entSearchContent-crawler-domainDetail-extractionRules-editRuleUrlFilters",
    options: [{
      id: UrlState.ALL,
      label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editRule.url.applyAllLabel', {
        defaultMessage: 'Apply to all URLs'
      })
    }, {
      id: UrlState.SPECIFIC,
      label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editRule.url.specificLabel', {
        defaultMessage: 'Apply to specific URLs'
      })
    }],
    idSelected: urlToggle,
    onChange: value => {
      setUrlToggle(value);
      // Make sure we always have one url filter when switching to specific URL filters
      if (value === UrlState.SPECIFIC && urlFiltersFields.length < 1) {
        setValue('url_filters', [{
          filter: _extraction_rules.ExtractionFilter.BEGINS,
          pattern: ''
        }]);
      } else {
        setValue('url_filters', []);
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), urlToggle === UrlState.SPECIFIC && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, urlFiltersFields.map((urlFilter, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    key: urlFilter.id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: `url_filters.${index}.filter`,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      helpText: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editRule.url.urlFilters.filterHelpText', {
        defaultMessage: 'What URLs should this apply to?'
      }),
      label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editRule.url.urlFilters.filterLabel', {
        defaultMessage: 'URL filter'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      "data-telemetry-id": "entSearchContent-crawler-domainDetail-extractionRules-urlFilter",
      fullWidth: true,
      inputRef: field.ref,
      value: field.value,
      onBlur: field.onBlur,
      onChange: field.onChange,
      options: extractionFilterOptions
    }))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: `url_filters.${index}.pattern`,
    rules: {
      validate: rule => {
        if (!(rule !== null && rule !== void 0 && rule.trim())) {
          return _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.fieldInput.requiredError', {
            defaultMessage: 'A value is required.'
          });
        }
        if (rule[0] !== '/') {
          return _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.fieldInput.slashMissingError', {
            defaultMessage: 'Value must begin with a /.'
          });
        }
        return true;
      }
    },
    render: ({
      field,
      fieldState: {
        error,
        isTouched
      }
    }) => {
      var _field$value2;
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        isInvalid: !!error && isTouched,
        error: error === null || error === void 0 ? void 0 : error.message,
        label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editRule.url.urlFilter.', {
          defaultMessage: 'URL pattern'
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        "data-telemetry-id": "entSearchContent-crawler-domainDetail-extractionRules-urlPattern",
        fullWidth: true,
        isInvalid: !!error && isTouched,
        placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editRule.url.urlFilters.patternPlaceholder', {
          defaultMessage: 'e.g. "/blog/*"'
        }),
        value: (_field$value2 = field.value) !== null && _field$value2 !== void 0 ? _field$value2 : '',
        onChange: field.onChange,
        onBlur: field.onBlur,
        inputRef: field.ref
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      alignSelf: 'center'
    }
  }, urlFiltersFields.length > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-telemetry-id": "entSearchContent-crawler-domainDetail-extractionRules-removeUrlFilter",
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editRule.url.urlFilters.removeFilter', {
      defaultMessage: 'Remove this filter'
    }),
    iconType: "trash",
    color: "danger",
    onClick: () => removeUrlFilter(index)
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": "entSearchContent-crawler-domainDetail-extractionRules-addUrlFilter",
    iconType: "plusInCircle",
    onClick: () => appendUrlFilter({
      filter: _extraction_rules.ExtractionFilter.BEGINS,
      pattern: ''
    })
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editRule.url.urlFilters.addFilter', {
    defaultMessage: 'Add URL filter'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-telemetry-id": "entSearchContent-crawler-domainDetail-extractionRules-learnMoreUrlFilters",
    href: `${_doc_links.docLinks.crawlerExtractionRules}#crawler-extraction-rules-html-filters`,
    external: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editRule.url.urlFiltersLink', {
    defaultMessage: 'Learn more about URL filters'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_content_fields_panel.ContentFieldsPanel, {
    contentFields: rulesFields,
    editExistingField: id => openEditRuleFlyout({
      fieldRule: rulesFields.find(({
        id: ruleId
      }) => ruleId === id),
      isNewRule: false
    }),
    editNewField: () => openEditRuleFlyout({
      isNewRule: true
    }),
    removeField: id => {
      const index = rulesFields.findIndex(({
        id: ruleId
      }) => ruleId === id);
      if (index >= 0) {
        removeRule(index);
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": "entSearchContent-crawler-domainDetail-extractionRules-cancelEditExtractionRule",
    onClick: cancelEditing
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editRule.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": "entSearchContent-crawler-domainDetail-extractionRules-saveExtractionRule",
    type: "submit",
    onClick: () => saveRule({
      ...getValues()
    }),
    disabled: !formState.isValid || !rulesFields || rulesFields.length === 0
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editRule.saveButtonLabel', {
    defaultMessage: 'Save rule'
  })))))), fieldRuleFlyoutVisible && /*#__PURE__*/_react.default.createElement(_edit_field_rule_flyout.EditFieldRuleFlyout, {
    fieldRule: fieldRuleToEdit,
    isNewRule: fieldRuleToEditIsNew,
    onClose: closeEditRuleFlyout
    // omit id and index so we don't break the API when submitting
    ,
    saveRule: ({
      id,
      index,
      ...fieldRule
    }) => {
      if (fieldRuleToEditIsNew) {
        appendRule(fieldRule);
      } else {
        const fieldRuleToEditIndex = rulesFields.findIndex(({
          id: ruleId
        }) => ruleId === id);
        updateRule(fieldRuleToEditIndex !== null && fieldRuleToEditIndex !== void 0 ? fieldRuleToEditIndex : 0, fieldRule);
      }
      closeEditRuleFlyout();
    }
  }));
};
exports.EditExtractionRule = EditExtractionRule;