"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APIGettingStarted = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _cloud_details = require("../../../../../shared/cloud_details/cloud_details");
var _getting_started = require("../../../../../shared/getting_started/getting_started");
var _index_view_logic = require("../../index_view_logic");
var _overview = require("../../overview.logic");
var _modal = require("../generate_api_key_modal/modal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_URL = 'https://localhost:9200';
const APIGettingStarted = () => {
  const {
    apiKey,
    isGenerateModalOpen,
    indexPipelineParameters
  } = (0, _kea.useValues)(_overview.OverviewLogic);
  const {
    fetchIndexPipelineParameters,
    openGenerateModal,
    closeGenerateModal
  } = (0, _kea.useActions)(_overview.OverviewLogic);
  const {
    indexName
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const cloudContext = (0, _cloud_details.useCloudDetails)();
  (0, _react.useEffect)(() => {
    fetchIndexPipelineParameters({
      indexName
    });
  }, [indexName]);
  const codeArgs = {
    apiKey,
    cloudId: cloudContext.cloudId,
    extraIngestDocumentValues: {
      _extract_binary_content: indexPipelineParameters.extract_binary_content,
      _reduce_whitespace: indexPipelineParameters.reduce_whitespace,
      _run_ml_inference: indexPipelineParameters.run_ml_inference
    },
    indexName,
    ingestPipeline: indexPipelineParameters.name,
    url: cloudContext.elasticsearchUrl || DEFAULT_URL
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isGenerateModalOpen && /*#__PURE__*/_react.default.createElement(_modal.GenerateApiKeyModal, {
    indexName: indexName,
    onClose: closeGenerateModal
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.gettingStarted.pageTitle', {
    defaultMessage: 'Getting started with Elastic API'
  }))), /*#__PURE__*/_react.default.createElement(_getting_started.GettingStarted, {
    openApiKeyModal: openGenerateModal,
    codeArgs: codeArgs
  }));
};
exports.APIGettingStarted = APIGettingStarted;