"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClientLibrariesPopover = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _client_libraries = require("../../../../../../assets/client_libraries");
var _doc_links = require("../../../../../shared/doc_links");
var _index_view_logic = require("../../index_view_logic");
var _overview = require("../../overview.logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const libraries = [{
  href: _doc_links.docLinks.clientsJavaIntroduction,
  icon: _client_libraries.icons.java,
  key: 'java',
  text: _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.documentExample.clientLibraries.java', {
    defaultMessage: 'Java'
  })
}, {
  href: _doc_links.docLinks.clientsJsIntro,
  icon: _client_libraries.icons.javascript,
  key: 'javascript',
  text: _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.documentExample.clientLibraries.javascript', {
    defaultMessage: 'Javascript / Node'
  })
}, {
  href: _doc_links.docLinks.clientsRubyOverview,
  icon: _client_libraries.icons.ruby,
  key: 'ruby',
  text: _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.documentExample.clientLibraries.ruby', {
    defaultMessage: 'Ruby'
  })
}, {
  href: _doc_links.docLinks.clientsGoIndex,
  icon: _client_libraries.icons.go,
  key: 'go',
  text: _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.documentExample.clientLibraries.go', {
    defaultMessage: 'Go'
  })
}, {
  href: _doc_links.docLinks.clientsNetIntroduction,
  icon: _client_libraries.icons.dotnet,
  key: 'dotnet',
  text: _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.documentExample.clientLibraries.dotnet', {
    defaultMessage: '.NET'
  })
}, {
  href: _doc_links.docLinks.clientsPhpGuide,
  icon: _client_libraries.icons.php,
  key: 'php',
  text: _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.documentExample.clientLibraries.php', {
    defaultMessage: 'PHP'
  })
}, {
  href: _doc_links.docLinks.clientsPerlGuide,
  icon: _client_libraries.icons.perl,
  key: 'perl',
  text: _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.documentExample.clientLibraries.perl', {
    defaultMessage: 'Perl'
  })
}, {
  href: _doc_links.docLinks.clientsPythonOverview,
  icon: _client_libraries.icons.python,
  key: 'python',
  text: _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.documentExample.clientLibraries.python', {
    defaultMessage: 'Python'
  })
}, {
  href: _doc_links.docLinks.clientsRustOverview,
  icon: _client_libraries.icons.rust,
  key: 'rust',
  text: _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.documentExample.clientLibraries.rust', {
    defaultMessage: 'Rust'
  })
}];
const ClientLibrariesPopover = () => {
  const {
    isClientsPopoverOpen
  } = (0, _kea.useValues)(_overview.OverviewLogic);
  const {
    ingestionMethod
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    toggleClientsPopover
  } = (0, _kea.useActions)(_overview.OverviewLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isClientsPopoverOpen,
    closePopover: toggleClientsPopover,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-telemetry-id": `entSearchContent-${ingestionMethod}-overview-clientLibraries-openClientLibraries`,
      iconType: "arrowDown",
      iconSide: "right",
      onClick: toggleClientsPopover
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content,overview.documentExample.clientLibraries.label', {
      defaultMessage: 'Client Libraries'
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: libraries.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: item.key,
      href: item.href,
      target: "_blank",
      icon: item.icon ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: item.icon,
        size: "l"
      }) : undefined
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, item.text))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "popout",
      size: "m",
      color: "primary"
    })))))
  }));
};
exports.ClientLibrariesPopover = ClientLibrariesPopover;