"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttachIndexLogic = void 0;
var _kea = require("kea");
var _api = require("../../../../../common/types/api");
var _attach_index_api_logic = require("../../api/connector/attach_index_api_logic");
var _create_api_index_api_logic = require("../../api/index/create_api_index_api_logic");
var _index_exists_api_logic = require("../../api/index/index_exists_api_logic");
var _connector_view_logic = require("./connector_view_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AttachIndexLogic = exports.AttachIndexLogic = (0, _kea.kea)({
  actions: {
    checkIndexExists: ({
      indexName
    }) => ({
      indexName
    }),
    setConnector: connector => connector
  },
  connect: {
    actions: [_attach_index_api_logic.AttachIndexApiLogic, ['makeRequest as attachIndex', 'apiSuccess as attachIndexApiSuccess', 'apiError as attachIndexApiError'], _create_api_index_api_logic.CreateApiIndexApiLogic, ['makeRequest as createIndex', 'apiSuccess as createIndexApiSuccess', 'apiError as createIndexApiError'], _index_exists_api_logic.IndexExistsApiLogic, ['makeRequest as callCheckIndexExists', 'apiSuccess as checkIndexExistsApiSuccess', 'apiError as checkIndexExistsApiError'], _connector_view_logic.ConnectorViewLogic, ['fetchConnector']],
    values: [_attach_index_api_logic.AttachIndexApiLogic, ['status as attachApiStatus', 'error as attachApiError'], _create_api_index_api_logic.CreateApiIndexApiLogic, ['status as createIndexApiStatus', 'error as createApiError'], _index_exists_api_logic.IndexExistsApiLogic, ['status as indexExistsApiStatus']]
  },
  listeners: ({
    actions,
    values
  }) => ({
    attachIndexApiSuccess: () => {
      if (values.connector) {
        actions.fetchConnector({
          connectorId: values.connector.id
        });
      }
    },
    checkIndexExists: async ({
      indexName
    }, breakpoint) => {
      await breakpoint(200);
      actions.callCheckIndexExists({
        indexName
      });
    },
    createIndexApiSuccess: async ({
      indexName
    }, breakpoint) => {
      if (values.connector) {
        var _values$connector;
        await breakpoint(500);
        actions.attachIndex({
          connectorId: (_values$connector = values.connector) === null || _values$connector === void 0 ? void 0 : _values$connector.id,
          indexName
        });
      }
    }
  }),
  path: ['enterprise_search', 'content', 'attach_index_logic'],
  reducers: {
    connector: [null, {
      setConnector: (_, connector) => connector
    }],
    indexExists: [{}, {
      checkIndexExistsApiSuccess: (state, {
        exists,
        indexName
      }) => ({
        ...state,
        [indexName]: exists
      })
    }]
  },
  selectors: ({
    selectors
  }) => ({
    isExistLoading: [() => [selectors.indexExistsApiStatus], indexExistsApiStatus => _api.Status.LOADING === indexExistsApiStatus],
    isLoading: [() => [selectors.attachApiStatus, selectors.createIndexApiStatus], (attachStatus, createStatus) => attachStatus === _api.Status.LOADING || createStatus === _api.Status.LOADING]
  })
});