"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlerRules = exports.CrawlerPolicies = exports.CrawlUnits = exports.CrawlType = void 0;
Object.defineProperty(exports, "CrawlerStatus", {
  enumerable: true,
  get: function () {
    return _crawler.CrawlerStatus;
  }
});
exports.CustomCrawlType = void 0;
var _crawler = require("../../../../../common/types/crawler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// TODO remove this proxy export, which will affect a lot of files
let CrawlerPolicies = exports.CrawlerPolicies = /*#__PURE__*/function (CrawlerPolicies) {
  CrawlerPolicies["allow"] = "allow";
  CrawlerPolicies["deny"] = "deny";
  return CrawlerPolicies;
}({});
let CrawlerRules = exports.CrawlerRules = /*#__PURE__*/function (CrawlerRules) {
  CrawlerRules["beginsWith"] = "begins";
  CrawlerRules["endsWith"] = "ends";
  CrawlerRules["contains"] = "contains";
  CrawlerRules["regex"] = "regex";
  return CrawlerRules;
}({});
// The BE uses a singular form of each unit
// See shared_togo/app/models/shared_togo/crawler/crawl_schedule.rb
let CrawlUnits = exports.CrawlUnits = /*#__PURE__*/function (CrawlUnits) {
  CrawlUnits["hours"] = "hour";
  CrawlUnits["days"] = "day";
  CrawlUnits["weeks"] = "week";
  CrawlUnits["months"] = "month";
  return CrawlUnits;
}({});
let CrawlType = exports.CrawlType = /*#__PURE__*/function (CrawlType) {
  CrawlType["Full"] = "full";
  CrawlType["Partial"] = "partial";
  return CrawlType;
}({}); // Server
// Client
let CustomCrawlType = exports.CustomCrawlType = /*#__PURE__*/function (CustomCrawlType) {
  CustomCrawlType["ONE_TIME"] = "one-time";
  CustomCrawlType["MULTIPLE"] = "multiple";
  return CustomCrawlType;
}({});