"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationError = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _error_state = require("../../../shared/error_state");
var _not_found = require("../../../shared/not_found");
var _telemetry = require("../../../shared/telemetry");
var _routes = require("../../routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchApplicationError = ({
  error,
  notFound
}) => {
  var _error$body;
  if (notFound || (error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.statusCode) === 404) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_telemetry.SendEnterpriseSearchTelemetry, {
      action: "error",
      metric: "not_found"
    }), /*#__PURE__*/_react.default.createElement(_not_found.NotFoundPrompt, {
      backToContent: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.notFound.action1', {
        defaultMessage: 'Back to Search Applications'
      }),
      backToLink: _routes.SEARCH_APPLICATIONS_PATH,
      productSupportUrl: _constants.APPLICATIONS_PLUGIN.SUPPORT_URL
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_telemetry.SendEnterpriseSearchTelemetry, {
    action: "error",
    metric: "cannot_connect"
  }), /*#__PURE__*/_react.default.createElement(_error_state.ErrorStatePrompt, null));
};
exports.SearchApplicationError = SearchApplicationError;