"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldIcon = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactField = require("@kbn/react-field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Remappings from type to a supported `FieldIcon` type
const typeToFieldIconType = {
  integer: 'number'
};

// Mappings for types missing from `FieldIcon`
const typeToEuiIconMap = {
  object: {
    color: 'euiColorVis3',
    iconType: 'tokenObject'
  }
};
const FieldIcon = props => {
  const type = typeToFieldIconType[props.type] || props.type;
  const overrides = typeToEuiIconMap[type] || {};
  return /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, (0, _extends2.default)({
    type: type
  }, overrides));
};
exports.FieldIcon = FieldIcon;