"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyState = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _doc_links = require("../../../../shared/doc_links");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyState = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: _.SynonymIcon,
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.synonyms.empty.title', {
      defaultMessage: 'Create your first synonym set'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.synonyms.empty.description', {
      defaultMessage: 'Synonyms relate queries with similar context or meaning together. Use them to guide users to relevant content.'
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      target: "_blank",
      iconType: "popout",
      href: _doc_links.docLinks.appSearchSynonyms
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.synonyms.empty.buttonLabel', {
      defaultMessage: 'Read the synonyms guide'
    }))
  }), /*#__PURE__*/_react.default.createElement(_.SynonymModal, null));
};
exports.EmptyState = EmptyState;