"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPDATE_SCHEMA_SUCCESS = exports.SCHEMA_TITLE = exports.ADD_SCHEMA_SUCCESS = exports.ADD_SCHEMA_ERROR = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SCHEMA_TITLE = exports.SCHEMA_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.title', {
  defaultMessage: 'Schema'
});
const ADD_SCHEMA_ERROR = fieldName => _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.addSchemaErrorMessage', {
  defaultMessage: 'Field name already exists: {fieldName}',
  values: {
    fieldName
  }
});
exports.ADD_SCHEMA_ERROR = ADD_SCHEMA_ERROR;
const ADD_SCHEMA_SUCCESS = fieldName => _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.addSchemaSuccessMessage', {
  defaultMessage: 'New field added: {fieldName}',
  values: {
    fieldName
  }
});
exports.ADD_SCHEMA_SUCCESS = ADD_SCHEMA_SUCCESS;
const UPDATE_SCHEMA_SUCCESS = exports.UPDATE_SCHEMA_SUCCESS = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.updateSchemaSuccessMessage', {
  defaultMessage: 'Schema updated'
});