"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnsearchedFieldsCallout = exports.UnconfirmedFieldsCallout = exports.SchemaCallouts = exports.MissingSubfieldsCallout = exports.ConfirmSchemaButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _schema = require("../../../../shared/schema");
var _app_logic = require("../../../app_logic");
var _routes = require("../../../routes");
var _engine = require("../../engine");
var _schema_logic = require("../schema_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SchemaCallouts = () => {
  const {
    myRole: {
      canManageEngines
    }
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    hasUnconfirmedFields,
    hasNewUnsearchedFields,
    mostRecentIndexJob: {
      hasErrors,
      activeReindexJobId
    },
    hasIncompleteFields
  } = (0, _kea.useValues)(_schema_logic.SchemaLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasErrors && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_schema.SchemaErrorsCallout, {
    viewErrorsPath: (0, _engine.generateEnginePath)(_routes.ENGINE_REINDEX_JOB_PATH, {
      reindexJobId: activeReindexJobId
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), hasUnconfirmedFields && canManageEngines && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasNewUnsearchedFields ? /*#__PURE__*/_react.default.createElement(UnsearchedFieldsCallout, null) : /*#__PURE__*/_react.default.createElement(UnconfirmedFieldsCallout, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), hasIncompleteFields && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(MissingSubfieldsCallout, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)));
};
exports.SchemaCallouts = SchemaCallouts;
const UnsearchedFieldsCallout = () => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  iconType: "iInCircle",
  title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.unsearchedFields.title', {
    defaultMessage: 'Recently added fields are not being searched by default'
  }),
  "data-test-subj": "schemaUnsearchedUnconfirmedFieldsCallout"
}, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.unsearchedFields.description', {
  defaultMessage: 'If these new fields should be searchable, update your search settings to include them. If you want them to remain unsearchable, confirm your new field types to dismiss this alert.'
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "s",
  responsive: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
  fill: true,
  size: "s",
  to: (0, _engine.generateEnginePath)(_routes.ENGINE_RELEVANCE_TUNING_PATH),
  "data-test-subj": "relevanceTuningButtonLink"
}, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.unsearchedFields.searchSettingsButtonLabel', {
  defaultMessage: 'Update search settings'
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(ConfirmSchemaButton, null))));
exports.UnsearchedFieldsCallout = UnsearchedFieldsCallout;
const UnconfirmedFieldsCallout = () => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  iconType: "iInCircle",
  title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.unconfirmedFields.title', {
    defaultMessage: "You've recently added new schema fields"
  }),
  "data-test-subj": "schemaUnconfirmedFieldsCallout"
}, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.unconfirmedFields.description', {
  defaultMessage: 'Set your new schema field(s) to their correct or expected types, and then confirm your field types.'
})), /*#__PURE__*/_react.default.createElement(ConfirmSchemaButton, null));
exports.UnconfirmedFieldsCallout = UnconfirmedFieldsCallout;
const ConfirmSchemaButton = () => {
  const {
    updateSchema
  } = (0, _kea.useActions)(_schema_logic.SchemaLogic);
  const {
    isUpdating
  } = (0, _kea.useValues)(_schema_logic.SchemaLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    isLoading: isUpdating,
    onClick: () => updateSchema(),
    "data-test-subj": "confirmSchemaTypesButton"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.confirmSchemaButtonLabel', {
    defaultMessage: 'Confirm types'
  }));
};
exports.ConfirmSchemaButton = ConfirmSchemaButton;
const MissingSubfieldsCallout = () => {
  const {
    incompleteFields
  } = (0, _kea.useValues)(_schema_logic.SchemaLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "warning",
    color: "warning",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.incompleteFields.title', {
      defaultMessage: '{count, plural, one {A field is} other {# fields are}} missing subfields',
      values: {
        count: incompleteFields.length
      }
    })
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.incompleteFields.description', {
    defaultMessage: 'Some fields are missing one or more subfields used by App Search. Some search features may not work until those subfields are added.'
  }), ' '), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: "https://www.elastic.co/guide/en/app-search/current/elasticsearch-engines-text-subfields-support-conventions.html",
    "data-test-subj": "missingSubfieldsLearnMoreLink",
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.incompleteFields.link', {
    defaultMessage: 'Learn more.'
  })));
};
exports.MissingSubfieldsCallout = MissingSubfieldsCallout;