"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelevanceTuningPreview = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _engine = require("../engine");
var _result = require("../result/result");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const emptyCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  "data-test-subj": "EmptyQueryPrompt",
  iconType: "glasses",
  body: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.preview.enterQueryMessage', {
    defaultMessage: 'Enter a query to see search results'
  })
});
const noResultsCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  "data-test-subj": "NoResultsPrompt",
  body: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.preview.noResultsMessage', {
    defaultMessage: 'No matching content found'
  })
});
const RelevanceTuningPreview = () => {
  const {
    setSearchQuery
  } = (0, _kea.useActions)(_.RelevanceTuningLogic);
  const {
    searchResults,
    schema
  } = (0, _kea.useValues)(_.RelevanceTuningLogic);
  const {
    engineName,
    isMetaEngine
  } = (0, _kea.useValues)(_engine.EngineLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.preview.title', {
    defaultMessage: 'Preview'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    onChange: e => setSearchQuery(e.target.value),
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.preview.searchPlaceholder', {
      defaultMessage: 'Search {engineName}',
      values: {
        engineName
      }
    }),
    fullWidth: true
  }), !searchResults && emptyCallout, searchResults && searchResults.length === 0 && noResultsCallout, searchResults && searchResults.map(result => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: result.id.raw
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_result.Result, {
      result: result,
      showScore: true,
      isMetaEngine: isMetaEngine,
      schemaForTypeHighlights: schema
    }));
  }));
};
exports.RelevanceTuningPreview = RelevanceTuningPreview;