"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextSearchToggle = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _types = require("../../../../../shared/schema/types");
var _relevance_tuning_logic = require("../../relevance_tuning_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TextSearchToggle = ({
  name,
  type,
  field
}) => {
  const {
    toggleSearchField
  } = (0, _kea.useActions)(_relevance_tuning_logic.RelevanceTuningLogic);
  const isText = type === _types.SchemaType.Text;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.manageFields.textSearch.rowLabel', {
      defaultMessage: 'Text search'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: !isText ? _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.manageFields.textSearch.warningLabel', {
      defaultMessage: 'Search can only be enabled on text fields'
    }) : _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.manageFields.textSearch.descriptionLabel', {
      defaultMessage: 'Search this field'
    }),
    onChange: () => isText && toggleSearchField(name, !!field),
    checked: !!field,
    disabled: !isText
  }));
};
exports.TextSearchToggle = TextSearchToggle;