"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderLastChangeLink = exports.renderEngineLink = exports.navigateToEngine = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _kibana = require("../../../../../shared/kibana");
var _react_router_helpers = require("../../../../../shared/react_router_helpers");
var _telemetry = require("../../../../../shared/telemetry");
var _routes = require("../../../../routes");
var _encode_path_params = require("../../../../utils/encode_path_params");
var _formatted_date_time = require("../../../../utils/formatted_date_time");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sendEngineTableLinkClickTelemetry = () => {
  _telemetry.TelemetryLogic.actions.sendAppSearchTelemetry({
    action: 'clicked',
    metric: 'engine_table_link'
  });
};
const navigateToEngine = engineName => {
  sendEngineTableLinkClickTelemetry();
  _kibana.KibanaLogic.values.navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.ENGINE_PATH, {
    engineName
  }));
};
exports.navigateToEngine = navigateToEngine;
const renderEngineLink = engineName => /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
  to: (0, _encode_path_params.generateEncodedPath)(_routes.ENGINE_PATH, {
    engineName
  }),
  onClick: sendEngineTableLinkClickTelemetry,
  "data-test-subj": "EngineName"
}, engineName);
exports.renderEngineLink = renderEngineLink;
const renderLastChangeLink = (dateString, onClick = () => {}) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  onClick: onClick
}, !dateString ? '-' : /*#__PURE__*/_react.default.createElement(_formatted_date_time.FormattedDateTime, {
  date: new Date(dateString),
  hideTime: true
}));
exports.renderLastChangeLink = renderLastChangeLink;