"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRedirectToAfterEngineCreation = exports.formatIndicesToSelectable = void 0;
var _reactRouterDom = require("react-router-dom");
var _dedent = _interopRequireDefault(require("dedent"));
var _routes = require("../../routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRedirectToAfterEngineCreation = ({
  ingestionMethod,
  engineName
}) => {
  if (ingestionMethod === 'crawler') {
    return (0, _reactRouterDom.generatePath)(_routes.ENGINE_CRAWLER_PATH, {
      engineName
    });
  }
  let enginePath = (0, _reactRouterDom.generatePath)(_routes.ENGINE_PATH, {
    engineName
  });
  if (ingestionMethod) {
    enginePath += `?method=${encodeURIComponent(ingestionMethod)}`;
  }
  return enginePath;
};
exports.getRedirectToAfterEngineCreation = getRedirectToAfterEngineCreation;
const formatIndicesToSelectable = (indices, selectedIndexName) => {
  return indices.filter(({
    alias,
    privileges
  }) => {
    if (alias) {
      return privileges.manage;
    } else {
      return privileges.read && privileges.manage;
    }
  }).map(index => {
    let icon;
    let color;
    let toolTipTitle;
    let toolTipContent;
    if (index.name.startsWith('search-')) {
      color = 'success';
      if (index.alias) {
        toolTipTitle = 'Alias is compatible';
        toolTipContent = 'You can use this alias.';
      } else {
        toolTipTitle = 'Index name is compatible';
        toolTipContent = (0, _dedent.default)(`
          You can directly use this index. You can also optionally create an
          alias to use as the source of the engine instead.
        `);
      }
    } else {
      if (index.alias) {
        icon = 'warning';
        color = 'danger';
        toolTipTitle = 'Alias name is incompatible';
        toolTipContent = 'You\'ll have to create a new alias prefixed with "search-".';
      } else {
        icon = 'iInCircle';
        color = 'warning';
        toolTipTitle = 'Index name is incompatible';
        toolTipContent = (0, _dedent.default)(`
          Enterprise Search will automatically create an alias to use as the
          source of the search engine rather than use this index directly.
        `);
      }
    }
    return {
      ...(selectedIndexName === index.name ? {
        checked: 'on'
      } : {}),
      alias: index.alias,
      badge: {
        color,
        toolTipTitle,
        toolTipContent,
        label: index.alias ? 'Alias' : 'Index',
        ...(icon ? {
          icon
        } : {})
      },
      count: index.count,
      disabled: index.alias && !index.name.startsWith('search-'),
      label: index.name,
      health: index.health,
      status: index.status,
      total: index.total
    };
  });
};
exports.formatIndicesToSelectable = formatIndicesToSelectable;