"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MoreDocumentsText = exports.ExampleDocumentJson = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExampleDocumentJson = ({
  document,
  errors
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, errors && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.showSummary.documentNotIndexed', {
    defaultMessage: 'This document was not indexed!'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), errors.map((errorMessage, index) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    size: "s",
    title: errorMessage
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    paddingSize: "m",
    overflowHeight: 200
  }, JSON.stringify(document, null, 2)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.ExampleDocumentJson = ExampleDocumentJson;
const MoreDocumentsText = ({
  documents
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.showSummary.otherDocuments', {
    defaultMessage: 'and {documents, number} other {documents, plural, one {document} other {documents}}.',
    values: {
      documents
    }
  })));
};
exports.MoreDocumentsText = MoreDocumentsText;