"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CurationResult = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _engine = require("../../../engine");
var _result = require("../../../result");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CurationResult = ({
  actions,
  dragHandleProps,
  result,
  index
}) => {
  const {
    isMetaEngine,
    engine: {
      schema
    }
  } = (0, _kea.useValues)(_engine.EngineLogic);
  return /*#__PURE__*/_react.default.createElement(_result.Result, {
    result: result,
    actions: actions,
    isMetaEngine: isMetaEngine,
    schemaForTypeHighlights: schema,
    dragHandleProps: dragHandleProps,
    resultPosition: typeof index === 'undefined' ? undefined : index + 1
  });
};
exports.CurationResult = CurationResult;