"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RECENT_API_EVENTS = exports.POLLING_ERROR_TITLE = exports.POLLING_ERROR_TEXT = exports.POLLING_DURATION = exports.API_LOGS_TITLE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const API_LOGS_TITLE = exports.API_LOGS_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.apiLogs.title', {
  defaultMessage: 'API Logs'
});
const RECENT_API_EVENTS = exports.RECENT_API_EVENTS = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.apiLogs.recent', {
  defaultMessage: 'Recent API events'
});
const POLLING_DURATION = exports.POLLING_DURATION = 5000;
const POLLING_ERROR_TITLE = exports.POLLING_ERROR_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.apiLogs.pollingErrorMessage', {
  defaultMessage: 'Could not refresh API log data'
});
const POLLING_ERROR_TEXT = exports.POLLING_ERROR_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.apiLogs.pollingErrorDescription', {
  defaultMessage: 'Please check your connection or manually reload the page.'
});