"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.X_AXIS_DATE_FORMAT = exports.TOTAL_QUERIES_NO_RESULTS = exports.TOTAL_QUERIES = exports.TOTAL_DOCUMENTS = exports.TOTAL_CLICKS = exports.TOTAL_API_OPERATIONS = exports.TOP_QUERIES_WITH_CLICKS = exports.TOP_QUERIES_NO_RESULTS = exports.TOP_QUERIES_NO_CLICKS = exports.TOP_QUERIES = exports.TOOLTIP_DATE_FORMAT = exports.SERVER_DATE_FORMAT = exports.RECENT_QUERIES = exports.DEFAULT_START_DATE = exports.DEFAULT_END_DATE = exports.ANALYTICS_TITLE = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ANALYTICS_TITLE = exports.ANALYTICS_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.title', {
  defaultMessage: 'Analytics'
});

// Total card titles
const TOTAL_DOCUMENTS = exports.TOTAL_DOCUMENTS = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.totalDocuments', {
  defaultMessage: 'Total documents'
});
const TOTAL_API_OPERATIONS = exports.TOTAL_API_OPERATIONS = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.totalApiOperations', {
  defaultMessage: 'Total API operations'
});
const TOTAL_QUERIES = exports.TOTAL_QUERIES = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.totalQueries', {
  defaultMessage: 'Total queries'
});
const TOTAL_QUERIES_NO_RESULTS = exports.TOTAL_QUERIES_NO_RESULTS = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.totalQueriesNoResults', {
  defaultMessage: 'Total queries with no results'
});
const TOTAL_CLICKS = exports.TOTAL_CLICKS = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.totalClicks', {
  defaultMessage: 'Total clicks'
});

// Queries sub-pages
const TOP_QUERIES = exports.TOP_QUERIES = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.topQueriesTitle', {
  defaultMessage: 'Top queries'
});
const TOP_QUERIES_NO_RESULTS = exports.TOP_QUERIES_NO_RESULTS = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.topQueriesNoResultsTitle', {
  defaultMessage: 'Top queries with no results'
});
const TOP_QUERIES_NO_CLICKS = exports.TOP_QUERIES_NO_CLICKS = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.topQueriesNoClicksTitle', {
  defaultMessage: 'Top queries with no clicks'
});
const TOP_QUERIES_WITH_CLICKS = exports.TOP_QUERIES_WITH_CLICKS = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.topQueriesWithClicksTitle', {
  defaultMessage: 'Top queries with clicks'
});
const RECENT_QUERIES = exports.RECENT_QUERIES = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.recentQueriesTitle', {
  defaultMessage: 'Recent queries'
});

// Date formats & dates
const SERVER_DATE_FORMAT = exports.SERVER_DATE_FORMAT = 'YYYY-MM-DD';
const TOOLTIP_DATE_FORMAT = exports.TOOLTIP_DATE_FORMAT = 'MMMM D, YYYY';
const X_AXIS_DATE_FORMAT = exports.X_AXIS_DATE_FORMAT = 'M/D';
const DEFAULT_START_DATE = exports.DEFAULT_START_DATE = (0, _moment.default)().subtract(6, 'days').format(SERVER_DATE_FORMAT);
const DEFAULT_END_DATE = exports.DEFAULT_END_DATE = (0, _moment.default)().format(SERVER_DATE_FORMAT);