"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RecentQueriesTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _formatted_date_time = require("../../../../utils/formatted_date_time");
var _shared_columns = require("./shared_columns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RecentQueriesTable = ({
  items
}) => {
  const TERM_COLUMN = {
    ..._shared_columns.TERM_COLUMN_PROPS,
    field: 'query_string'
  };
  const TIME_COLUMN = {
    field: 'timestamp',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.table.timeColumn', {
      defaultMessage: 'Time'
    }),
    render: timestamp => /*#__PURE__*/_react.default.createElement(_formatted_date_time.FormattedDateTime, {
      date: new Date(timestamp)
    }),
    width: '200px'
  };
  const RESULTS_COLUMN = {
    ..._shared_columns.COUNT_COLUMN_PROPS,
    field: 'document_ids',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.table.resultsColumn', {
      defaultMessage: 'Results'
    }),
    render: documents => documents.length
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: [TERM_COLUMN, TIME_COLUMN, _shared_columns.TAGS_LIST_COLUMN, RESULTS_COLUMN, _shared_columns.ACTIONS_COLUMN],
    items: items,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "visLine",
      title: /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.table.empty.noRecentQueriesTitle', {
        defaultMessage: 'No recent queries'
      })),
      body: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.table.empty.noRecentQueriesDescription', {
        defaultMessage: 'Queries will appear here as they are received.'
      })
    })
  });
};
exports.RecentQueriesTable = RecentQueriesTable;