"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteAnalyticsCollection = exports.DeleteAnalyticsCollectionAPILogic = void 0;
var _i18n = require("@kbn/i18n");
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteAnalyticsCollection = async ({
  name
}) => {
  const {
    http
  } = _http.HttpLogic.values;
  const route = `/internal/elasticsearch/analytics/collections/${name}`;
  await http.delete(route);
  return;
};
exports.deleteAnalyticsCollection = deleteAnalyticsCollection;
const DeleteAnalyticsCollectionAPILogic = exports.DeleteAnalyticsCollectionAPILogic = (0, _create_api_logic.createApiLogic)(['analytics', 'delete_analytics_collection_api_logic'], deleteAnalyticsCollection, {
  showSuccessFlashFn: () => _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collectionsDelete.action.successMessage', {
    defaultMessage: 'The collection has been successfully deleted'
  })
});