"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VectorSearchPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/constants");
var _doc_links = require("../../../shared/doc_links");
var _http = require("../../../shared/http");
var _kibana = require("../../../shared/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VectorSearchPanel = () => {
  const {
    http
  } = (0, _kea.useValues)(_http.HttpLogic);
  const {
    application
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.aiSearch.vectorSearchPanel.description",
    defaultMessage: "Use {vectorDbCapabilities} by adding embeddings from your ML models.",
    values: {
      vectorDbCapabilities: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "enterpriseSearchVectorSearchPanelElasticsearchsVectorDbCapabilitiesLink",
        "data-telemetry-id": "entSearch-aiSearch-semanticSearch-vectorSearchPanel-knnSearchLink",
        target: "_blank",
        href: _doc_links.docLinks.knnSearch,
        external: false
      }, _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.vectorSearchPanel.description.vectorDbCapabilitiesLinkText', {
        defaultMessage: "Elasticsearch's vector DB capabilities"
      }))
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "enterpriseSearchVectorSearchPanelLink",
    onClick: () => {
      application.navigateToUrl(http.basePath.prepend(`${_constants.VECTOR_SEARCH_PLUGIN.URL}`));
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enterpriseSearchVectorSearchPanelCreateAnIndexButton",
    "data-telemetry-id": "entSearch-aiSearch-semanticSearch-vectorSearchPanel-vectorSearchPage"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.vectorSearchPanel.buttonLabel', {
    defaultMessage: 'Set up Vector Search'
  }))))));
};
exports.VectorSearchPanel = VectorSearchPanel;