"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getModelOrOss = exports.getFormattedTime = void 0;
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * use oss as model when using openai and oss
 * else default to given model
 * if no model exists, let undefined and resolveProviderAndModel logic will determine the model from connector
 * @param llmType
 * @param isOssModel
 * @param model
 */
const getModelOrOss = (llmType, isOssModel, model) => llmType === 'openai' && isOssModel ? 'oss' : model;
exports.getModelOrOss = getModelOrOss;
const TIME_FORMAT = 'llll [UTC]Z';
const UTC_CONVERSION_TIME_FORMAT = 'LT [UTC]';
const getFormattedTime = ({
  screenContextTimezone,
  uiSettingsDateFormatTimezone
}) => {
  var _ref;
  const currentTimezone = (_ref = uiSettingsDateFormatTimezone === 'Browser' ? screenContextTimezone : uiSettingsDateFormatTimezone) !== null && _ref !== void 0 ? _ref : 'UTC';
  const now = new Date();
  const currentFormatter = _momentTimezone.default.tz(now, currentTimezone);
  const utcFormatter = _momentTimezone.default.tz(now, 'UTC');

  // If the local timezone is different from UTC, we should show the UTC time as well
  const utcConversionRequired = currentFormatter.format('[UTC]Z') !== utcFormatter.format('[UTC]Z');
  const currentTime = currentFormatter.format(TIME_FORMAT);
  const utcConversion = utcConversionRequired ? utcFormatter.format(UTC_CONVERSION_TIME_FORMAT) : undefined;
  return `Current time: ${currentTime} ${utcConversion ? `(${utcConversion})` : ''}`.trim();
};
exports.getFormattedTime = getFormattedTime;