"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadSecurityLabs = exports.getSecurityLabsDocsCount = void 0;
var _promises = require("fs/promises");
var _directory = require("langchain/document_loaders/fs/directory");
var _path = require("path");
var _pMap = _interopRequireDefault(require("p-map"));
var _aiSecurityLabsContent = require("@kbn/ai-security-labs-content");
var _add_required_kb_resource_metadata = require("./add_required_kb_resource_metadata");
var _constants = require("../../../routes/knowledge_base/constants");
var _encoded_security_labs_content_loader = require("./encoded_security_labs_content_loader");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Loads the Elastic Security Labs mdx files into the Knowledge Base.
 */
const loadSecurityLabs = async (kbDataClient, logger) => {
  try {
    var _response$length;
    const docsLoader = new _directory.DirectoryLoader((0, _path.resolve)(__dirname, '../../../knowledge_base/security_labs'), {
      '.md': path => new _encoded_security_labs_content_loader.EncodedSecurityLabsContentLoader(path)
    }, true);
    const rawDocs = await docsLoader.load();

    // Add additional metadata to set kbResource as esql
    const docs = (0, _add_required_kb_resource_metadata.addRequiredKbResourceMetadata)({
      docs: rawDocs,
      kbResource: _constants.SECURITY_LABS_RESOURCE,
      required: false
    });
    logger.info(`Loading ${docs.length} Security Labs docs into the Knowledge Base`);

    /**
     * Ingest Security Labs docs into the Knowledge Base one by one to avoid blocking
     * Inference Endpoint for too long
     */

    const response = (await (0, _pMap.default)(docs, singleDoc => kbDataClient.addKnowledgeBaseDocuments({
      documents: [singleDoc],
      global: true
    }), {
      concurrency: 1
    })).flat();
    logger.info(`Loaded ${(_response$length = response === null || response === void 0 ? void 0 : response.length) !== null && _response$length !== void 0 ? _response$length : 0} Security Labs docs into the Knowledge Base`);
    return response.length > 0;
  } catch (e) {
    logger.error(`Failed to load Security Labs docs into the Knowledge Base\n${e}`);
    return false;
  }
};
exports.loadSecurityLabs = loadSecurityLabs;
const getSecurityLabsDocsCount = async ({
  logger
}) => {
  try {
    // @ts-expect-error incorrect type for Array.fromAsync
    const files = await Array.fromAsync((0, _promises.glob)(_aiSecurityLabsContent.ENCODED_FILE_MICROMATCH_PATTERN, {
      cwd: (0, _path.resolve)(__dirname, '../../../knowledge_base/security_labs')
    }));
    return files.length;
  } catch (e) {
    logger.error(`Failed to get Security Labs source docs count\n${e}`);
    return 0;
  }
};
exports.getSecurityLabsDocsCount = getSecurityLabsDocsCount;