"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertUrl = void 0;
var _common = require("@kbn/spaces-plugin/common");
var _constants = require("../../../../schedules/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAlertUrl = ({
  alertDocId,
  basePath,
  spaceId
}) => {
  const alertDetailPath = `/attack_discovery?id=${alertDocId}`;
  const alertDetailPathWithAppPath = `${_constants.SECURITY_APP_PATH}${alertDetailPath}`;
  return basePath ? (0, _common.addSpaceIdToPath)(basePath, spaceId !== null && spaceId !== void 0 ? spaceId : undefined, alertDetailPathWithAppPath) : undefined;
};
exports.getAlertUrl = getAlertUrl;