"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isMissingRequiredFields = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _field_names = require("../../../../schedules/fields/field_names");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** Returns `true` if the document is missing fields required to create an `AttackDiscoveryAlert` */
const isMissingRequiredFields = hit => hit._source == null || hit._source['@timestamp'] == null || !Array.isArray(hit._source[_field_names.ALERT_ATTACK_DISCOVERY_ALERT_IDS]) || hit._source[_field_names.ALERT_ATTACK_DISCOVERY_ALERTS_CONTEXT_COUNT] == null || hit._source[_field_names.ALERT_ATTACK_DISCOVERY_API_CONFIG] == null || hit._source[_field_names.ALERT_ATTACK_DISCOVERY_API_CONFIG].action_type_id == null || hit._source[_field_names.ALERT_ATTACK_DISCOVERY_API_CONFIG].connector_id == null || hit._source[_field_names.ALERT_ATTACK_DISCOVERY_API_CONFIG].name == null || hit._source[_field_names.ALERT_ATTACK_DISCOVERY_DETAILS_MARKDOWN] == null || hit._source[_ruleDataUtils.ALERT_RULE_EXECUTION_UUID] == null || hit._id == null || hit._source[_field_names.ALERT_ATTACK_DISCOVERY_SUMMARY_MARKDOWN] == null || hit._source[_field_names.ALERT_ATTACK_DISCOVERY_TITLE] == null;
exports.isMissingRequiredFields = isMissingRequiredFields;