"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformSearchResponseToAlerts = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _moment = _interopRequireDefault(require("moment"));
var _is_missing_required_fields = require("./is_missing_required_fields");
var _field_names = require("../../../schedules/fields/field_names");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const aggregationHasValue = aggregation => typeof aggregation === 'object' && aggregation !== null && 'value' in aggregation && typeof aggregation.value === 'number';
const transformSearchResponseToAlerts = ({
  logger,
  response
}) => {
  var _response$aggregation, _response$aggregation2, _connectorNamesAggreg, _connectorNamesAggreg2;
  const data = response.hits.hits.flatMap(hit => {
    var _source$ALERT_ATTACK_, _source$ALERT_ATTACK_2, _source$ALERT_RULE_EX, _ref, _hit$_id, _source$ALERT_ATTACK_3, _source$ALERT_ATTACK_4;
    if (hit._source == null || (0, _is_missing_required_fields.isMissingRequiredFields)(hit)) {
      logger.warn(() => `Skipping Attack discovery alert document with id ${hit._id} in transformSearchResponseToAlerts because it's missing required fields.`);
      return []; // skip this hit
    }
    const source = hit._source;

    // NOTE: we won't return this hit if `isMissingRequiredFields` above returns  `false`
    return {
      alertIds: (_source$ALERT_ATTACK_ = source[_field_names.ALERT_ATTACK_DISCOVERY_ALERT_IDS]) !== null && _source$ALERT_ATTACK_ !== void 0 ? _source$ALERT_ATTACK_ : [],
      // required field
      alertRuleUuid: source[_ruleDataUtils.ALERT_RULE_UUID],
      alertStart: (0, _moment.default)(source[_ruleDataUtils.ALERT_START]).isValid() ? (0, _moment.default)(source[_ruleDataUtils.ALERT_START]).toISOString() : undefined,
      // optional field
      alertUpdatedAt: (0, _moment.default)(source[_ruleDataUtils.ALERT_UPDATED_AT]).isValid() ? (0, _moment.default)(source[_ruleDataUtils.ALERT_UPDATED_AT]).toISOString() : undefined,
      // optional field
      alertUpdatedByUserId: source[_ruleDataUtils.ALERT_UPDATED_BY_USER_ID],
      alertUpdatedByUserName: source[_ruleDataUtils.ALERT_UPDATED_BY_USER_NAME],
      alertWorkflowStatus: source[_ruleDataUtils.ALERT_WORKFLOW_STATUS],
      alertWorkflowStatusUpdatedAt: (0, _moment.default)(source[_ruleDataUtils.ALERT_WORKFLOW_STATUS_UPDATED_AT]).isValid() ? (0, _moment.default)(source[_ruleDataUtils.ALERT_WORKFLOW_STATUS_UPDATED_AT]).toISOString() : undefined,
      // optional field
      connectorId: source[_field_names.ALERT_ATTACK_DISCOVERY_API_CONFIG].connector_id,
      // required field
      connectorName: source[_field_names.ALERT_ATTACK_DISCOVERY_API_CONFIG].name,
      detailsMarkdown: (_source$ALERT_ATTACK_2 = source[_field_names.ALERT_ATTACK_DISCOVERY_DETAILS_MARKDOWN]) !== null && _source$ALERT_ATTACK_2 !== void 0 ? _source$ALERT_ATTACK_2 : '',
      // required field
      entitySummaryMarkdown: source[_field_names.ALERT_ATTACK_DISCOVERY_ENTITY_SUMMARY_MARKDOWN],
      generationUuid: (_source$ALERT_RULE_EX = source[_ruleDataUtils.ALERT_RULE_EXECUTION_UUID]) !== null && _source$ALERT_RULE_EX !== void 0 ? _source$ALERT_RULE_EX : '',
      // required field
      id: (_ref = (_hit$_id = hit._id) !== null && _hit$_id !== void 0 ? _hit$_id : source[_ruleDataUtils.ALERT_RULE_EXECUTION_UUID]) !== null && _ref !== void 0 ? _ref : '',
      // required field
      mitreAttackTactics: Array.isArray(source[_field_names.ALERT_ATTACK_DISCOVERY_MITRE_ATTACK_TACTICS]) ? source[_field_names.ALERT_ATTACK_DISCOVERY_MITRE_ATTACK_TACTICS] : undefined,
      replacements: Array.isArray(source[_field_names.ALERT_ATTACK_DISCOVERY_REPLACEMENTS]) ? (0, _elasticAssistantCommon.transformInternalReplacements)(source[_field_names.ALERT_ATTACK_DISCOVERY_REPLACEMENTS]) : undefined,
      riskScore: source[_field_names.ALERT_RISK_SCORE],
      summaryMarkdown: (_source$ALERT_ATTACK_3 = source[_field_names.ALERT_ATTACK_DISCOVERY_SUMMARY_MARKDOWN]) !== null && _source$ALERT_ATTACK_3 !== void 0 ? _source$ALERT_ATTACK_3 : '',
      // required field
      timestamp: (0, _moment.default)(source['@timestamp']).isValid() ? (0, _moment.default)(source['@timestamp']).toISOString() : new Date().toISOString(),
      // required field
      title: (_source$ALERT_ATTACK_4 = source[_field_names.ALERT_ATTACK_DISCOVERY_TITLE]) !== null && _source$ALERT_ATTACK_4 !== void 0 ? _source$ALERT_ATTACK_4 : '',
      // required field
      userId: source[_field_names.ALERT_ATTACK_DISCOVERY_USER_ID],
      userName: source[_field_names.ALERT_ATTACK_DISCOVERY_USER_NAME],
      users: Array.isArray(source[_field_names.ALERT_ATTACK_DISCOVERY_USERS]) ? source[_field_names.ALERT_ATTACK_DISCOVERY_USERS] : undefined
    };
  });
  const uniqueAlertIdsCountAggregation = (_response$aggregation = response.aggregations) === null || _response$aggregation === void 0 ? void 0 : _response$aggregation.unique_alert_ids_count;
  const uniqueAlertIdsCount = aggregationHasValue(uniqueAlertIdsCountAggregation) ? uniqueAlertIdsCountAggregation.value : 0;
  const connectorNamesAggregation = (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.api_config_name;
  const connectorNames = (_connectorNamesAggreg = connectorNamesAggregation === null || connectorNamesAggregation === void 0 ? void 0 : (_connectorNamesAggreg2 = connectorNamesAggregation.buckets) === null || _connectorNamesAggreg2 === void 0 ? void 0 : _connectorNamesAggreg2.flatMap(bucket => {
    var _bucket$key;
    return (_bucket$key = bucket.key) !== null && _bucket$key !== void 0 ? _bucket$key : [];
  })) !== null && _connectorNamesAggreg !== void 0 ? _connectorNamesAggreg : [];
  return {
    connectorNames: [...connectorNames].sort(),
    // mutation
    data,
    uniqueAlertIdsCount
  };
};
exports.transformSearchResponseToAlerts = transformSearchResponseToAlerts;