"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetAttackDiscoveryGenerationsSearchResult = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GetAttackDiscoveryGenerationsSearchResult = exports.GetAttackDiscoveryGenerationsSearchResult = _zod.z.object({
  aggregations: _zod.z.object({
    generations: _zod.z.object({
      buckets: _zod.z.array(_zod.z.object({
        key: _zod.z.string(),
        // UUID of the generation
        doc_count: _zod.z.number(),
        alerts_context_count: _zod.z.object({
          value: _zod.z.number().nullable().optional()
        }),
        connector_id: _zod.z.object({
          buckets: _zod.z.array(_zod.z.object({
            key: _zod.z.string(),
            doc_count: _zod.z.number()
          }))
        }),
        discoveries: _zod.z.object({
          value: _zod.z.number().nullable().optional()
        }),
        event_actions: _zod.z.object({
          buckets: _zod.z.array(_zod.z.object({
            key: _zod.z.string(),
            doc_count: _zod.z.number()
          }))
        }),
        event_reason: _zod.z.object({
          buckets: _zod.z.array(_zod.z.object({
            key: _zod.z.string(),
            doc_count: _zod.z.number()
          }))
        }),
        loading_message: _zod.z.object({
          buckets: _zod.z.array(_zod.z.object({
            key: _zod.z.string(),
            doc_count: _zod.z.number()
          }))
        }),
        generation_end_time: _zod.z.object({
          value_as_string: _zod.z.string().nullable().optional()
        }),
        generation_start_time: _zod.z.object({
          value_as_string: _zod.z.string().nullable().optional() // optional to handle missing values
        })
      }))
    })
  })
});