"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGenerateOrRefineOrEndEdge = void 0;
var _get_generate_or_refine_or_end_decision = require("./helpers/get_generate_or_refine_or_end_decision");
var _get_has_results = require("../helpers/get_has_results");
var _get_has_zero_alerts = require("../helpers/get_has_zero_alerts");
var _get_max_hallucination_failures_reached = require("../../helpers/get_max_hallucination_failures_reached");
var _get_max_retries_reached = require("../../helpers/get_max_retries_reached");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getGenerateOrRefineOrEndEdge = logger => {
  const edge = state => {
    logger === null || logger === void 0 ? void 0 : logger.debug(() => '---GENERATE OR REFINE OR END---');
    const {
      anonymizedAlerts,
      generationAttempts,
      hallucinationFailures,
      maxGenerationAttempts,
      maxHallucinationFailures,
      unrefinedResults
    } = state;
    const hasZeroAlerts = (0, _get_has_zero_alerts.getHasZeroAlerts)(anonymizedAlerts);
    const hasUnrefinedResults = (0, _get_has_results.getHasResults)(unrefinedResults);
    const maxRetriesReached = (0, _get_max_retries_reached.getMaxRetriesReached)({
      generationAttempts,
      maxGenerationAttempts
    });
    const maxHallucinationFailuresReached = (0, _get_max_hallucination_failures_reached.getMaxHallucinationFailuresReached)({
      hallucinationFailures,
      maxHallucinationFailures
    });
    const decision = (0, _get_generate_or_refine_or_end_decision.getGenerateOrRefineOrEndDecision)({
      hasUnrefinedResults,
      hasZeroAlerts,
      maxHallucinationFailuresReached,
      maxRetriesReached
    });
    logger === null || logger === void 0 ? void 0 : logger.debug(() => {
      var _unrefinedResults$len;
      return `generatOrRefineOrEndEdge evaluated the following (derived) state:\n${JSON.stringify({
        anonymizedAlerts: anonymizedAlerts.length,
        generationAttempts,
        hallucinationFailures,
        hasUnrefinedResults,
        hasZeroAlerts,
        maxHallucinationFailuresReached,
        maxRetriesReached,
        unrefinedResults: (_unrefinedResults$len = unrefinedResults === null || unrefinedResults === void 0 ? void 0 : unrefinedResults.length) !== null && _unrefinedResults$len !== void 0 ? _unrefinedResults$len : 0
      }, null, 2)}
        \n---GENERATE OR REFINE OR END: ${decision}---`;
    });
    return decision;
  };
  return edge;
};
exports.getGenerateOrRefineOrEndEdge = getGenerateOrRefineOrEndEdge;