"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUpdateAttackDiscoveryAlertsQuery = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _fields = require("../schedules/fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUpdateAttackDiscoveryAlertsQuery = ({
  authenticatedUser,
  ids,
  indexPattern,
  kibanaAlertWorkflowStatus,
  visibility
}) => ({
  allow_no_indices: true,
  conflicts: 'proceed',
  ignore_unavailable: true,
  index: [indexPattern],
  query: {
    ids: {
      values: ids
    }
  },
  script: {
    source: `
      def now = new Date();

      if (params.kibanaAlertWorkflowStatus != null) {
        ctx._source['${_ruleDataUtils.ALERT_WORKFLOW_STATUS}'] = params.kibanaAlertWorkflowStatus;
        ctx._source['${_ruleDataUtils.ALERT_WORKFLOW_STATUS_UPDATED_AT}'] = now;
      }

    if (params.visibility == 'not_shared') {
      ctx._source['${_fields.ALERT_ATTACK_DISCOVERY_USERS}'] = new ArrayList();

      Map user = new HashMap();
      user.put('id', params.authenticatedUser.profile_uid);
      user.put('name', params.authenticatedUser.username);

      ctx._source['${_fields.ALERT_ATTACK_DISCOVERY_USERS}'].add(user);

      ctx._source['${_ruleDataUtils.TIMESTAMP}'] = now;
    } else if (params.visibility == 'shared') {
      ctx._source['${_fields.ALERT_ATTACK_DISCOVERY_USERS}'] = new ArrayList();

      ctx._source['${_ruleDataUtils.TIMESTAMP}'] = now;
    }

    ctx._source['${_ruleDataUtils.ALERT_UPDATED_AT}'] = now;
    ctx._source['${_ruleDataUtils.ALERT_UPDATED_BY_USER_ID}'] = params.authenticatedUser.profile_uid;
    ctx._source['${_ruleDataUtils.ALERT_UPDATED_BY_USER_NAME}'] = params.authenticatedUser.username;
    `,
    params: {
      authenticatedUser: {
        profile_uid: authenticatedUser.profile_uid,
        username: authenticatedUser.username
      },
      kibanaAlertWorkflowStatus,
      visibility
    }
  }
});
exports.getUpdateAttackDiscoveryAlertsQuery = getUpdateAttackDiscoveryAlertsQuery;