"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformToUpdateScheme = exports.transformToCreateScheme = exports.transformESToPrompts = exports.transformESSearchToPrompts = exports.getUpdateScript = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformESToPrompts = response => {
  return response.map(promptSchema => {
    var _promptSchema$users$m, _promptSchema$users;
    const prompt = {
      timestamp: promptSchema['@timestamp'],
      createdAt: promptSchema.created_at,
      users: (_promptSchema$users$m = (_promptSchema$users = promptSchema.users) === null || _promptSchema$users === void 0 ? void 0 : _promptSchema$users.map(user => ({
        id: user.id,
        name: user.name
      }))) !== null && _promptSchema$users$m !== void 0 ? _promptSchema$users$m : [],
      content: promptSchema.content,
      isDefault: promptSchema.is_default,
      isNewConversationDefault: promptSchema.is_new_conversation_default,
      updatedAt: promptSchema.updated_at,
      namespace: promptSchema.namespace,
      id: promptSchema.id,
      name: promptSchema.name,
      promptType: promptSchema.prompt_type,
      color: promptSchema.color,
      categories: promptSchema.categories,
      consumer: promptSchema.consumer,
      createdBy: promptSchema.created_by,
      updatedBy: promptSchema.updated_by
    };
    return prompt;
  });
};
exports.transformESToPrompts = transformESToPrompts;
const transformESSearchToPrompts = response => {
  return response.hits.hits.filter(hit => hit._source !== undefined).map(hit => {
    var _promptSchema$users$m2, _promptSchema$users2;
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    const promptSchema = hit._source;
    const prompt = {
      timestamp: promptSchema['@timestamp'],
      createdAt: promptSchema.created_at,
      users: (_promptSchema$users$m2 = (_promptSchema$users2 = promptSchema.users) === null || _promptSchema$users2 === void 0 ? void 0 : _promptSchema$users2.map(user => ({
        id: user.id,
        name: user.name
      }))) !== null && _promptSchema$users$m2 !== void 0 ? _promptSchema$users$m2 : [],
      content: promptSchema.content,
      isDefault: promptSchema.is_default,
      isNewConversationDefault: promptSchema.is_new_conversation_default,
      updatedAt: promptSchema.updated_at,
      namespace: promptSchema.namespace,
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      id: hit._id,
      name: promptSchema.name,
      promptType: promptSchema.prompt_type,
      color: promptSchema.color,
      categories: promptSchema.categories,
      consumer: promptSchema.consumer,
      createdBy: promptSchema.created_by,
      updatedBy: promptSchema.updated_by
    };
    return prompt;
  });
};
exports.transformESSearchToPrompts = transformESSearchToPrompts;
const transformToUpdateScheme = (user, updatedAt, {
  content,
  isNewConversationDefault,
  categories,
  color,
  id
}) => {
  return {
    id,
    updated_at: updatedAt,
    content: content !== null && content !== void 0 ? content : '',
    is_new_conversation_default: isNewConversationDefault,
    categories,
    color,
    users: [{
      id: user.profile_uid,
      name: user.username
    }]
  };
};
exports.transformToUpdateScheme = transformToUpdateScheme;
const transformToCreateScheme = (user, updatedAt, {
  content,
  isDefault,
  isNewConversationDefault,
  categories,
  color,
  consumer,
  name,
  promptType
}) => {
  return {
    '@timestamp': updatedAt,
    updated_at: updatedAt,
    content: content !== null && content !== void 0 ? content : '',
    is_new_conversation_default: isNewConversationDefault,
    color,
    consumer,
    categories,
    name,
    is_default: isDefault,
    prompt_type: promptType,
    users: [{
      id: user.profile_uid,
      name: user.username
    }]
  };
};
exports.transformToCreateScheme = transformToCreateScheme;
const getUpdateScript = ({
  prompt,
  isPatch
}) => {
  return {
    script: {
      source: `
    if (params.assignEmpty == true || params.containsKey('content')) {
      ctx._source.content = params.content;
    }
    if (params.assignEmpty == true || params.containsKey('is_new_conversation_default')) {
      ctx._source.is_new_conversation_default = params.is_new_conversation_default;
    }
    if (params.assignEmpty == true || params.containsKey('color')) {
      ctx._source.color = params.color;
    }
    if (params.assignEmpty == true || params.containsKey('categories')) {
      ctx._source.categories = params.categories;
    }
    ctx._source.updated_at = params.updated_at;
  `,
      lang: 'painless',
      params: {
        ...prompt,
        // when assigning undefined in painless, it will remove property and wil set it to null
        // for patch we don't want to remove unspecified value in payload
        assignEmpty: !(isPatch !== null && isPatch !== void 0 ? isPatch : true)
      }
    }
  };
};
exports.getUpdateScript = getUpdateScript;