"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AI_IS_CURRENTLY_ANALYZING_RANGE = exports.AI_IS_CURRENTLY_ANALYZING_FROM = exports.AI_IS_CURRENTLY_ANALYZING = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AI_IS_CURRENTLY_ANALYZING = alertsCount => _i18n.i18n.translate('xpack.elasticAssistantCommon.attackDiscovery.getLoadingMessage.aiIsCurrentlyAnalyzing', {
  defaultMessage: `AI is analyzing up to {alertsCount} {alertsCount, plural, =1 {alert} other {alerts}} in the last 24 hours to generate discoveries.`,
  values: {
    alertsCount
  }
});
exports.AI_IS_CURRENTLY_ANALYZING = AI_IS_CURRENTLY_ANALYZING;
const AI_IS_CURRENTLY_ANALYZING_FROM = ({
  alertsCount,
  from
}) => _i18n.i18n.translate('xpack.elasticAssistantCommon.attackDiscovery.getLoadingMessage.aiIsCurrentlyAnalyzingFromLabel', {
  defaultMessage: `AI is analyzing up to {alertsCount} {alertsCount, plural, =1 {alert} other {alerts}} {from} to generate discoveries.`,
  values: {
    alertsCount,
    from
  }
});
exports.AI_IS_CURRENTLY_ANALYZING_FROM = AI_IS_CURRENTLY_ANALYZING_FROM;
const AI_IS_CURRENTLY_ANALYZING_RANGE = ({
  alertsCount,
  end,
  start
}) => _i18n.i18n.translate('xpack.elasticAssistantCommon.attackDiscovery.getLoadingMessage.aiIsCurrentlyAnalyzingRangeLabel', {
  defaultMessage: `AI is analyzing up to {alertsCount} {alertsCount, plural, =1 {alert} other {alerts}} from {start} to {end} to generate discoveries.`,
  values: {
    alertsCount,
    end,
    start
  }
});
exports.AI_IS_CURRENTLY_ANALYZING_RANGE = AI_IS_CURRENTLY_ANALYZING_RANGE;