"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertEventRowIndicator = void 0;
var _discoverUtils = require("@kbn/discover-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getAlertEventRowIndicator = (row, euiTheme) => {
  let eventColor = euiTheme.colors.backgroundLightText;
  let rowLabel = 'event';
  if ((0, _discoverUtils.getFieldValue)(row, 'event.kind') === 'signal') {
    eventColor = euiTheme.colors.warning;
    rowLabel = 'alert';
  }
  return {
    color: eventColor,
    label: rowLabel
  };
};
exports.getAlertEventRowIndicator = getAlertEventRowIndicator;